/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.joda.time.LocalDateTime;
import org.junit.Assert;

public class BoundaryTimerEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testMultipleTimersOnUserTask() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multipleTimersOnUserTask");
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerEventTest.assertEquals((int)3, (int)jobs.size());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3605000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryTimerEventTest.assertEquals((String)"Third Task", (String)task.getName());
    }

    @Deployment
    public void testTimerOnNestingOfSubprocesses() {
        this.runtimeService.startProcessInstanceByKey("timerOnNestedSubprocesses");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryTimerEventTest.assertEquals((int)2, (int)tasks.size());
        BoundaryTimerEventTest.assertEquals((String)"Inner subprocess task 1", (String)((Task)tasks.get(0)).getName());
        BoundaryTimerEventTest.assertEquals((String)"Inner subprocess task 2", (String)((Task)tasks.get(1)).getName());
        Job timer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(timer.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryTimerEventTest.assertEquals((String)"task outside subprocess", (String)task.getName());
    }

    @Deployment
    public void testExpressionOnTimer() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duration", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerEventTest.assertEquals((int)1, (int)jobs.size());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3605000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testRecalculateUnchangedExpressionOnTimerCurrentDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerEventTest.assertEquals((int)1, (int)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        Date currentTime = new Date(startTime.getTime() + TimeUnit.MINUTES.toMillis(5L));
        ClockUtil.setCurrentTime((Date)currentTime);
        this.managementService.recalculateJobDuedate(job.getId(), false);
        Job jobUpdated = (Job)jobQuery.singleResult();
        BoundaryTimerEventTest.assertEquals((String)job.getId(), (String)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        BoundaryTimerEventTest.assertTrue((boolean)oldDate.before(jobUpdated.getDuedate()));
        Date expectedDate = LocalDateTime.fromDateFields((Date)currentTime).plusHours(1).toDate();
        Assertions.assertThat((Date)jobUpdated.getDuedate()).isCloseTo(expectedDate, 1000L);
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.HOURS.toMillis(1L) + TimeUnit.MINUTES.toMillis(6L)));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerEventTest.testRecalculateUnchangedExpressionOnTimerCurrentDateBased.bpmn20.xml"})
    public void testRecalculateUnchangedExpressionOnTimerCreationDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerEventTest.assertEquals((int)1, (int)jobs.size());
        Job job = (Job)jobs.get(0);
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.SECONDS.toMillis(5L)));
        this.managementService.recalculateJobDuedate(job.getId(), true);
        Job jobUpdated = (Job)jobQuery.singleResult();
        BoundaryTimerEventTest.assertEquals((String)job.getId(), (String)jobUpdated.getId());
        Date expectedDate = LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusHours(1).toDate();
        BoundaryTimerEventTest.assertEquals((Object)expectedDate, (Object)jobUpdated.getDuedate());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.HOURS.toMillis(1L) + TimeUnit.SECONDS.toMillis(15L)));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerEventTest.testRecalculateUnchangedExpressionOnTimerCurrentDateBased.bpmn20.xml"})
    public void testRecalculateChangedExpressionOnTimerCurrentDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerEventTest.assertEquals((int)1, (int)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        ClockUtil.offset((Long)2000L);
        this.managementService.recalculateJobDuedate(job.getId(), false);
        Job jobUpdated = (Job)jobQuery.singleResult();
        BoundaryTimerEventTest.assertEquals((String)job.getId(), (String)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        BoundaryTimerEventTest.assertTrue((boolean)oldDate.before(jobUpdated.getDuedate()));
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.HOURS.toMillis(2L)));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerEventTest.testRecalculateUnchangedExpressionOnTimerCurrentDateBased.bpmn20.xml"})
    public void testRecalculateChangedExpressionOnTimerCreationDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerEventTest.assertEquals((int)1, (int)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        this.runtimeService.setVariable(pi.getId(), "duedate", (Object)"PT15M");
        this.managementService.recalculateJobDuedate(job.getId(), true);
        Job jobUpdated = (Job)jobQuery.singleResult();
        BoundaryTimerEventTest.assertEquals((String)job.getId(), (String)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        BoundaryTimerEventTest.assertEquals((Object)LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusMinutes(15).toDate(), (Object)jobUpdated.getDuedate());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.MINUTES.toMillis(16L)));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTimerInSingleTransactionProcess() {
        this.runtimeService.startProcessInstanceByKey("timerOnSubprocesses");
        BoundaryTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testRepeatingTimerWithCancelActivity() {
        this.runtimeService.startProcessInstanceByKey("repeatingTimerAndCallActivity");
        BoundaryTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        BoundaryTimerEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        BoundaryTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        BoundaryTimerEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    public void testMultipleOutgoingSequenceFlows() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("interruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        BoundaryTimerEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        BoundaryTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testMultipleOutgoingSequenceFlowsOnSubprocess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("interruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        BoundaryTimerEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        BoundaryTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testMultipleOutgoingSequenceFlowsOnSubprocessMi() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("interruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        BoundaryTimerEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        BoundaryTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testInterruptingTimerDuration() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("escalationExample");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        BoundaryTimerEventTest.assertEquals((String)"First line support", (String)task.getName());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        BoundaryTimerEventTest.assertEquals((String)"Handle escalated issue", (String)task.getName());
    }
}

