/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.activation;

import java.util.Collections;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;

public class ManualActivationRuleTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testVariableBasedRule.cmmn"})
    public void testManualActivationRuleEvaluatesToTrue() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        ManualActivationRuleTest.assertNotNull((Object)taskExecution);
        ManualActivationRuleTest.assertTrue((boolean)taskExecution.isEnabled());
        ManualActivationRuleTest.assertFalse((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testVariableBasedRule.cmmn"})
    public void testManualActivationRuleEvaluatesToFalse() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        ManualActivationRuleTest.assertNotNull((Object)taskExecution);
        ManualActivationRuleTest.assertFalse((boolean)taskExecution.isEnabled());
        ManualActivationRuleTest.assertTrue((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultManualActivationRuleEvaluatesToTrue() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        ManualActivationRuleTest.assertNotNull((Object)taskExecution);
        ManualActivationRuleTest.assertTrue((boolean)taskExecution.isEnabled());
        ManualActivationRuleTest.assertFalse((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultManualActivationRuleEvaluatesToFalse() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        ManualActivationRuleTest.assertNotNull((Object)taskExecution);
        ManualActivationRuleTest.assertFalse((boolean)taskExecution.isEnabled());
        ManualActivationRuleTest.assertTrue((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testActivationWithoutDefinition.cmmn"})
    public void testActivationWithoutManualActivationDefined() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertThat((Object)taskExecution, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)taskExecution.isEnabled(), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)"Human Task is active, when ManualActivation is omitted", (Object)taskExecution.isActive(), (Matcher)Is.is((Object)true));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testActivationWithoutManualActivationExpressionDefined.cmmn"})
    public void testActivationWithoutManualActivationExpressionDefined() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertThat((Object)taskExecution, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)taskExecution.isEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)"Human Task is not active, when ManualActivation's condition is empty", (Object)taskExecution.isActive(), (Matcher)Is.is((Object)false));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testActivationWithoutManualActivationConditionDefined.cmmn"})
    public void testActivationWithoutManualActivationConditionDefined() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertThat((Object)taskExecution, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)taskExecution.isEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)"Human Task is not active, when ManualActivation's condition is empty", (Object)taskExecution.isActive(), (Matcher)Is.is((Object)false));
    }
}

