/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Map;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.cmd.SetTaskVariablesCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.variable.Variables;

public class CompetingCompleteTaskSetVariableTest
extends ConcurrencyTestCase {
    @Deployment
    public void testCompleteTaskSetLocalVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableSetTaskVariablesCommand(taskId, (Map<String, ? extends Object>)Variables.createVariables().putValue("var", (Object)"value")));
        thread1.reportInterrupts();
        thread1.waitForSync();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableCompleteTaskCommand(taskId));
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitUntilDone();
        thread2.makeContinue();
        thread2.waitUntilDone();
        CompetingCompleteTaskSetVariableTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{taskId}).count());
        CompetingCompleteTaskSetVariableTest.assertNotNull((Object)thread2.exception);
        CompetingCompleteTaskSetVariableTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskId(taskId).count());
    }

    public class ControllableSetTaskVariablesCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String taskId;
        protected Map<String, ? extends Object> variables;
        protected Exception exception;

        public ControllableSetTaskVariablesCommand(String taskId, Map<String, ? extends Object> variables) {
            this.taskId = taskId;
            this.variables = variables;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new SetTaskVariablesCmd(this.taskId, this.variables, true).execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableCompleteTaskCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String taskId;
        protected Exception exception;

        public ControllableCompleteTaskCommand(String taskId) {
            this.taskId = taskId;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new CompleteTaskCmd(this.taskId, null).execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

