/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManagerFactory;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.util.DatabaseHelper;

public class JdbcStatementTimeoutTest
extends ConcurrencyTestCase {
    private static final int STATEMENT_TIMEOUT_IN_SECONDS = 1;
    private static final int TEST_TIMEOUT_IN_MILLIS = 10000;
    private static final String JOB_ENTITY_ID = "42";
    private ConcurrencyTestCase.ThreadControl thread1;
    private ConcurrencyTestCase.ThreadControl thread2;

    protected void runTest() throws Throwable {
        String databaseType = DatabaseHelper.getDatabaseType(this.processEngineConfiguration);
        if (!"db2".equals(databaseType) && !"mariadb".equals(databaseType) || !this.processEngine.getProcessEngineConfiguration().isJdbcBatchProcessing()) {
            super.runTest();
        }
    }

    protected void initializeProcessEngine() {
        this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml").setJdbcStatementTimeout(Integer.valueOf(1)).buildProcessEngine();
    }

    protected void closeDownProcessEngine() {
        this.processEngine.close();
        this.processEngine = null;
    }

    public void testTimeoutOnUpdate() {
        this.createJobEntity();
        this.thread1 = this.executeControllableCommand(new UpdateJobCommand("p1"));
        this.thread1.waitForSync();
        this.thread2 = this.executeControllableCommand(new UpdateJobCommand("p2"));
        this.thread2.waitForSync();
        this.thread1.makeContinue();
        this.thread1.waitForSync();
        this.thread2.makeContinue();
        this.thread2.reportInterrupts();
        this.thread2.waitForSync(10000L);
        JdbcStatementTimeoutTest.assertNotNull((String)"expected timeout exception", (Object)this.thread2.getException());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.thread1 != null) {
            this.thread1.waitUntilDone();
            this.deleteJobEntities();
        }
    }

    private void createJobEntity() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<JobEntity>(){

            public JobEntity execute(CommandContext commandContext) {
                MessageEntity jobEntity = new MessageEntity();
                jobEntity.setId(JdbcStatementTimeoutTest.JOB_ENTITY_ID);
                jobEntity.insert();
                return jobEntity;
            }
        });
    }

    private void deleteJobEntities() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = commandContext.getDbEntityManager().createJobQuery().list();
                for (Job job : jobs) {
                    commandContext.getJobManager().deleteJob((JobEntity)job, false);
                }
                for (HistoricJobLog jobLog : commandContext.getDbEntityManager().createHistoricJobLogQuery().list()) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(jobLog.getId());
                }
                return null;
            }
        });
    }

    static class UpdateJobCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String lockOwner;

        public UpdateJobCommand(String lockOwner) {
            this.lockOwner = lockOwner;
        }

        public Void execute(CommandContext commandContext) {
            DbEntityManagerFactory dbEntityManagerFactory = new DbEntityManagerFactory(Context.getProcessEngineConfiguration().getIdGenerator());
            DbEntityManager entityManager = dbEntityManagerFactory.openSession();
            JobEntity job = (JobEntity)entityManager.selectById(JobEntity.class, JdbcStatementTimeoutTest.JOB_ENTITY_ID);
            job.setLockOwner(this.lockOwner);
            entityManager.forceUpdate((DbEntity)job);
            this.monitor.sync();
            entityManager.flush();
            this.monitor.sync();
            commandContext.getTransactionContext().commit();
            return null;
        }
    }
}

