/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.junit.Assert;

@RequiredHistoryLevel(value="full")
public class HistoricIncidentTest
extends PluggableProcessEngineTestCase {
    private static String PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testPropertiesOfHistoricIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        HistoricIncidentTest.assertNotNull((Object)incident);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        HistoricIncidentTest.assertNotNull((Object)historicIncident);
        HistoricJobLog jobLog = this.getHistoricJobLogOrdered(incident.getConfiguration()).get(0);
        HistoricIncidentTest.assertEquals((String)incident.getId(), (String)historicIncident.getId());
        HistoricIncidentTest.assertEquals((Object)incident.getIncidentTimestamp(), (Object)historicIncident.getCreateTime());
        HistoricIncidentTest.assertNull((Object)historicIncident.getEndTime());
        HistoricIncidentTest.assertEquals((String)incident.getIncidentType(), (String)historicIncident.getIncidentType());
        HistoricIncidentTest.assertEquals((String)incident.getIncidentMessage(), (String)historicIncident.getIncidentMessage());
        HistoricIncidentTest.assertEquals((String)incident.getExecutionId(), (String)historicIncident.getExecutionId());
        HistoricIncidentTest.assertEquals((String)incident.getActivityId(), (String)historicIncident.getActivityId());
        HistoricIncidentTest.assertEquals((String)incident.getProcessInstanceId(), (String)historicIncident.getProcessInstanceId());
        HistoricIncidentTest.assertEquals((String)incident.getProcessDefinitionId(), (String)historicIncident.getProcessDefinitionId());
        HistoricIncidentTest.assertEquals((String)PROCESS_DEFINITION_KEY, (String)historicIncident.getProcessDefinitionKey());
        HistoricIncidentTest.assertEquals((String)incident.getCauseIncidentId(), (String)historicIncident.getCauseIncidentId());
        HistoricIncidentTest.assertEquals((String)incident.getRootCauseIncidentId(), (String)historicIncident.getRootCauseIncidentId());
        HistoricIncidentTest.assertEquals((String)incident.getConfiguration(), (String)historicIncident.getConfiguration());
        HistoricIncidentTest.assertEquals((String)incident.getJobDefinitionId(), (String)historicIncident.getJobDefinitionId());
        HistoricIncidentTest.assertEquals((String)jobLog.getId(), (String)historicIncident.getHistoryConfiguration());
        HistoricIncidentTest.assertTrue((boolean)historicIncident.isOpen());
        HistoricIncidentTest.assertFalse((boolean)historicIncident.isDeleted());
        HistoricIncidentTest.assertFalse((boolean)historicIncident.isResolved());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testCreateSecondHistoricIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        this.executeAvailableJobs();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentTest.assertEquals((long)2L, (long)query.count());
        HistoricIncidentTest.assertEquals((long)1L, (long)query.resolved().count());
        query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentTest.assertEquals((long)1L, (long)query.open().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testJobLogReferenceWithMultipleHistoricIncidents() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        this.executeAvailableJobs();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentTest.assertEquals((long)2L, (long)query.count());
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(jobId);
        HistoricIncidentTest.assertEquals((String)logs.get(1).getId(), (String)((HistoricIncident)query.resolved().singleResult()).getHistoryConfiguration());
        query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentTest.assertEquals((String)logs.get(0).getId(), (String)((HistoricIncident)query.open().singleResult()).getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSetHistoricIncidentToResolved() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        HistoricIncidentTest.assertNotNull((Object)historicIncident);
        HistoricIncidentTest.assertNotNull((Object)historicIncident.getEndTime());
        HistoricIncidentTest.assertFalse((boolean)historicIncident.isOpen());
        HistoricIncidentTest.assertFalse((boolean)historicIncident.isDeleted());
        HistoricIncidentTest.assertTrue((boolean)historicIncident.isResolved());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSetHistoricIncidentToResolvedRecursive() {
        this.startProcessInstance("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        for (HistoricIncident historicIncident : historicIncidents) {
            HistoricIncidentTest.assertNotNull((Object)historicIncident.getEndTime());
            HistoricIncidentTest.assertFalse((boolean)historicIncident.isOpen());
            HistoricIncidentTest.assertFalse((boolean)historicIncident.isDeleted());
            HistoricIncidentTest.assertTrue((boolean)historicIncident.isResolved());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSetHistoricIncidentToDeleted() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        HistoricIncidentTest.assertNotNull((Object)historicIncident);
        HistoricIncidentTest.assertNotNull((Object)historicIncident.getEndTime());
        HistoricIncidentTest.assertFalse((boolean)historicIncident.isOpen());
        HistoricIncidentTest.assertTrue((boolean)historicIncident.isDeleted());
        HistoricIncidentTest.assertFalse((boolean)historicIncident.isResolved());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSetHistoricIncidentToDeletedRecursive() {
        this.startProcessInstance("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult()).getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        for (HistoricIncident historicIncident : historicIncidents) {
            HistoricIncidentTest.assertNotNull((Object)historicIncident.getEndTime());
            HistoricIncidentTest.assertFalse((boolean)historicIncident.isOpen());
            HistoricIncidentTest.assertTrue((boolean)historicIncident.isDeleted());
            HistoricIncidentTest.assertFalse((boolean)historicIncident.isResolved());
        }
    }

    @Deployment
    public void testCreateHistoricIncidentForNestedExecution() {
        this.startProcessInstance("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("serviceTask").singleResult();
        HistoricIncidentTest.assertNotNull((Object)execution);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        HistoricIncidentTest.assertNotNull((Object)historicIncident);
        HistoricJobLog jobLog = this.getHistoricJobLogOrdered(historicIncident.getConfiguration()).get(0);
        HistoricIncidentTest.assertEquals((String)execution.getId(), (String)historicIncident.getExecutionId());
        HistoricIncidentTest.assertEquals((String)"serviceTask", (String)historicIncident.getActivityId());
        HistoricIncidentTest.assertEquals((String)jobLog.getId(), (String)historicIncident.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testCreateRecursiveHistoricIncidents() {
        this.startProcessInstance("process");
        ProcessInstance pi1 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        HistoricIncidentTest.assertNotNull((Object)pi1);
        ProcessInstance pi2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        HistoricIncidentTest.assertNotNull((Object)pi2);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncident rootCauseHistoricIncident = (HistoricIncident)query.processInstanceId(pi2.getId()).singleResult();
        HistoricIncidentTest.assertNotNull((Object)rootCauseHistoricIncident);
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)rootCauseHistoricIncident.getCauseIncidentId());
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)rootCauseHistoricIncident.getRootCauseIncidentId());
        HistoricIncident historicIncident = (HistoricIncident)query.processInstanceId(pi1.getId()).singleResult();
        HistoricIncidentTest.assertNotNull((Object)historicIncident);
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)historicIncident.getCauseIncidentId());
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)historicIncident.getRootCauseIncidentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testJobLogReferenceForRecursiveHistoricIncident() {
        this.startProcessInstance("process");
        ProcessInstance pi1 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        ProcessInstance pi2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        HistoricIncident rootCauseHistoricIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(pi2.getId()).singleResult();
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(pi1.getId()).singleResult();
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(rootCauseHistoricIncident.getConfiguration());
        HistoricIncidentTest.assertEquals((String)logs.get(0).getId(), (String)rootCauseHistoricIncident.getHistoryConfiguration());
        HistoricIncidentTest.assertNull((Object)historicIncident.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentTest.testCreateRecursiveHistoricIncidentsForNestedCallActivities.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testCreateRecursiveHistoricIncidentsForNestedCallActivities() {
        this.startProcessInstance("process1");
        ProcessInstance pi1 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process1").singleResult();
        HistoricIncidentTest.assertNotNull((Object)pi1);
        ProcessInstance pi2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        HistoricIncidentTest.assertNotNull((Object)pi2);
        ProcessInstance pi3 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        HistoricIncidentTest.assertNotNull((Object)pi3);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncident rootCauseHistoricIncident = (HistoricIncident)query.processInstanceId(pi3.getId()).singleResult();
        HistoricIncidentTest.assertNotNull((Object)rootCauseHistoricIncident);
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)rootCauseHistoricIncident.getCauseIncidentId());
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)rootCauseHistoricIncident.getRootCauseIncidentId());
        HistoricIncident causeHistoricIncident = (HistoricIncident)query.processInstanceId(pi2.getId()).singleResult();
        HistoricIncidentTest.assertNotNull((Object)causeHistoricIncident);
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)causeHistoricIncident.getCauseIncidentId());
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)causeHistoricIncident.getRootCauseIncidentId());
        HistoricIncident historicIncident = (HistoricIncident)query.processInstanceId(pi1.getId()).singleResult();
        HistoricIncidentTest.assertNotNull((Object)historicIncident);
        HistoricIncidentTest.assertEquals((String)causeHistoricIncident.getId(), (String)historicIncident.getCauseIncidentId());
        HistoricIncidentTest.assertEquals((String)rootCauseHistoricIncident.getId(), (String)historicIncident.getRootCauseIncidentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testDoNotCreateNewIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        HistoricIncidentTest.assertNotNull((Object)incident);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        HistoricIncident tmp = (HistoricIncident)query.singleResult();
        HistoricIncidentTest.assertEquals((String)incident.getId(), (String)tmp.getId());
        HistoricIncidentTest.assertNull((Object)tmp.getEndTime());
        HistoricIncidentTest.assertTrue((boolean)tmp.isOpen());
        this.executeAvailableJobs();
        HistoricIncidentTest.assertEquals((long)1L, (long)query.count());
        tmp = (HistoricIncident)query.singleResult();
        HistoricIncidentTest.assertEquals((String)incident.getId(), (String)tmp.getId());
        HistoricIncidentTest.assertNull((Object)tmp.getEndTime());
        HistoricIncidentTest.assertTrue((boolean)tmp.isOpen());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testJobLogReferenceWithNoNewIncidentCreatedOnFailure() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        String jobId = incident.getConfiguration();
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(jobId);
        HistoricIncidentTest.assertEquals((String)logs.get(0).getId(), (String)incident.getHistoryConfiguration());
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 2);
        this.executeAvailableJobs(false);
        HistoricIncidentTest.assertEquals((long)1L, (long)query.count());
        HistoricIncident incidentNew = (HistoricIncident)query.singleResult();
        List<HistoricJobLog> logsNew = this.getHistoricJobLogOrdered(jobId);
        HistoricIncidentTest.assertEquals((String)incident.getId(), (String)incidentNew.getId());
        HistoricIncidentTest.assertEquals((String)incident.getHistoryConfiguration(), (String)incidentNew.getHistoryConfiguration());
        HistoricIncidentTest.assertTrue((logsNew.size() > logs.size() ? 1 : 0) != 0);
        this.executeAvailableJobs(false);
        HistoricIncidentTest.assertEquals((long)1L, (long)query.count());
        incidentNew = (HistoricIncident)query.singleResult();
        logsNew = this.getHistoricJobLogOrdered(jobId);
        HistoricIncidentTest.assertTrue((logsNew.size() > logs.size() ? 1 : 0) != 0);
        HistoricIncidentTest.assertEquals((String)incident.getId(), (String)incidentNew.getId());
        Assert.assertNotEquals((Object)incident.getHistoryConfiguration(), (Object)incidentNew.getHistoryConfiguration());
        HistoricIncidentTest.assertEquals((String)logsNew.get(0).getId(), (String)incidentNew.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testJobLogReferenceWithNewIncidentCreatedOnSetRetriesAfterFailure() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY, false);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ClockUtil.offset((Long)2000L);
        this.executeAvailableJobs(false);
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(job.getId());
        HistoricIncidentTest.assertEquals((int)2, (int)logs.size());
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncidentTest.assertEquals((long)0L, (long)query.count());
        this.managementService.setJobRetries(job.getId(), 0);
        HistoricIncidentTest.assertEquals((long)1L, (long)query.count());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        HistoricIncidentTest.assertEquals((String)logs.get(0).getId(), (String)incident.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSetRetriesByJobDefinitionIdResolveIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        HistoricIncidentTest.assertNotNull((Object)incident);
        this.runtimeService.setVariable(pi.getId(), "fail", (Object)false);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        HistoricIncident tmp = (HistoricIncident)query.singleResult();
        HistoricIncidentTest.assertEquals((String)incident.getId(), (String)tmp.getId());
        HistoricIncidentTest.assertNull((Object)tmp.getEndTime());
        HistoricIncidentTest.assertTrue((boolean)tmp.isOpen());
        this.executeAvailableJobs();
        HistoricIncidentTest.assertEquals((long)1L, (long)query.count());
        tmp = (HistoricIncident)query.singleResult();
        HistoricIncidentTest.assertEquals((String)incident.getId(), (String)tmp.getId());
        HistoricIncidentTest.assertNotNull((Object)tmp.getEndTime());
        HistoricIncidentTest.assertTrue((boolean)tmp.isResolved());
        this.assertProcessEnded(pi.getId());
    }

    protected void startProcessInstance(String key) {
        this.startProcessInstances(key, 1, true);
    }

    protected void startProcessInstance(String key, boolean recursive) {
        this.startProcessInstances(key, 1, recursive);
    }

    protected void startProcessInstances(String key, int numberOfInstances, boolean recursive) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
        this.executeAvailableJobs(recursive);
    }

    protected List<HistoricJobLog> getHistoricJobLogOrdered(String jobId) {
        return ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().failureLog().jobId(jobId).orderPartiallyByOccurrence().desc()).list();
    }
}

