/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.dmn;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.junit.Assert;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String DECISION_CASE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn";
    protected static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_UNDERSCORE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask_.bpmn20.xml";
    protected static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    protected static final String DECISION_SINGLE_OUTPUT_DMN_WITH_UNDERSCORE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput_.dmn11.xml";
    protected static final String DECISION_NO_INPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.noInput.dmn11.xml";
    protected static final String DRG_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";
    protected static final String DISH_DECISION = "dish-decision";

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryIncludeInputsForNonExistingDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeInputs();
        Assert.assertThat((Object)query.singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.startProcessInstanceAndEvaluateDecision();
        Assert.assertThat((Object)query.decisionInstanceId("nonExisting").singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryIncludeOutputs() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            ((HistoricDecisionInstance)query.singleResult()).getOutputs();
            HistoricDecisionInstanceQueryTest.fail((String)"expected exception: output not fetched");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertThat((Object)((HistoricDecisionInstance)query.includeOutputs().singleResult()).getOutputs().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryIncludeOutputsForNonExistingDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeOutputs();
        Assert.assertThat((Object)query.singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.startProcessInstanceAndEvaluateDecision();
        Assert.assertThat((Object)query.decisionInstanceId("nonExisting").singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.noInput.dmn11.xml"})
    public void testQueryIncludeInputsNoInput() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)((HistoricDecisionInstance)query.includeInputs().singleResult()).getInputs().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.noInput.dmn11.xml"})
    public void testQueryIncludeOutputsNoInput() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)((HistoricDecisionInstance)query.includeOutputs().singleResult()).getOutputs().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryPaging() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.listPage(0, 2).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)query.listPage(1, 1).size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQuerySortByEvaluationTime() {
        this.startProcessInstanceAndEvaluateDecision();
        this.waitASignificantAmountOfTime();
        this.startProcessInstanceAndEvaluateDecision();
        List orderAsc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByEvaluationTime().asc()).list();
        Assert.assertThat((Object)((HistoricDecisionInstance)orderAsc.get(0)).getEvaluationTime().before(((HistoricDecisionInstance)orderAsc.get(1)).getEvaluationTime()), (Matcher)CoreMatchers.is((Object)true));
        List orderDesc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByEvaluationTime().desc()).list();
        Assert.assertThat((Object)((HistoricDecisionInstance)orderDesc.get(0)).getEvaluationTime().after(((HistoricDecisionInstance)orderDesc.get(1)).getEvaluationTime()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionInstanceId() {
        ProcessInstance pi1 = this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance pi2 = this.startProcessInstanceAndEvaluateDecision();
        String decisionInstanceId1 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi1.getId()).singleResult()).getId();
        String decisionInstanceId2 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi2.getId()).singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionInstanceId(decisionInstanceId1).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceId(decisionInstanceId2).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceId("unknown").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionInstanceIds() {
        ProcessInstance pi1 = this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance pi2 = this.startProcessInstanceAndEvaluateDecision();
        String decisionInstanceId1 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi1.getId()).singleResult()).getId();
        String decisionInstanceId2 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi2.getId()).singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionInstanceIdIn(new String[]{decisionInstanceId1}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceIdIn(new String[]{decisionInstanceId2}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceIdIn(new String[]{decisionInstanceId1, decisionInstanceId2}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionDefinitionId() {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionId(decisionDefinitionId).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionDefinitionId("other id").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByDecisionDefinitionIdIn() {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String decisionDefinitionId2 = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DISH_DECISION).singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionIdIn(new String[]{decisionDefinitionId, decisionDefinitionId2}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.decisionDefinitionIdIn(new String[]{"other id", "anotherFake"}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByInvalidDecisionDefinitionIdIn() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            query.decisionDefinitionIdIn(new String[]{"aFake", null}).count();
            HistoricDecisionInstanceQueryTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByDecisionDefinitionKeyIn() {
        this.startProcessInstanceAndEvaluateDecision();
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionKeyIn(new String[]{DISH_DECISION, DECISION_DEFINITION_KEY}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.decisionDefinitionKeyIn(new String[]{"other id", "anotherFake"}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByInvalidDecisionDefinitionKeyIn() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            query.decisionDefinitionKeyIn(new String[]{"aFake", null}).count();
            HistoricDecisionInstanceQueryTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionDefinitionKey() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionKey(DECISION_DEFINITION_KEY).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionDefinitionKey("other key").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionDefinitionName() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionName("sample decision").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionDefinitionName("other name").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask_.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput_.dmn11.xml"})
    public void testQueryByDecisionDefinitionNameLike() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecisionWithUnderscore();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionNameLike("%ample dec%").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionDefinitionNameLike("%ample\\_%").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByInvalidDecisionDefinitionNameLike() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionNameLike("%invalid%").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.decisionDefinitionNameLike(null);
            HistoricDecisionInstanceQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByProcessDefinitionKey() {
        String processDefinitionKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.processDefinitionKey(processDefinitionKey).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.processDefinitionKey("other process").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.processDefinitionId(processDefinitionId).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.processDefinitionId("other process").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByProcessInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.processInstanceId(processInstanceId).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.processInstanceId("other process").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByActivityId() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.activityIdIn(new String[]{"task"}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.activityIdIn(new String[]{"other activity"}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.activityIdIn(new String[]{"task", "other activity"}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByActivityInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.activityInstanceIdIn(new String[]{activityInstanceId}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.activityInstanceIdIn(new String[]{"other activity"}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.activityInstanceIdIn(new String[]{activityInstanceId, "other activity"}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByEvaluatedBefore() {
        Date beforeEvaluated = new Date(1441612000L);
        Date evaluated = new Date(1441613000L);
        Date afterEvaluated = new Date(1441614000L);
        ClockUtil.setCurrentTime((Date)evaluated);
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.evaluatedBefore(afterEvaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedBefore(evaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedBefore(beforeEvaluated).count(), (Matcher)CoreMatchers.is((Object)0L));
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByEvaluatedAfter() {
        Date beforeEvaluated = new Date(1441612000L);
        Date evaluated = new Date(1441613000L);
        Date afterEvaluated = new Date(1441614000L);
        ClockUtil.setCurrentTime((Date)evaluated);
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.evaluatedAfter(beforeEvaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedAfter(evaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedAfter(afterEvaluated).count(), (Matcher)CoreMatchers.is((Object)0L));
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByCaseDefinitionKey() {
        this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionKey("case").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByInvalidCaseDefinitionKey() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionKey("invalid").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.caseDefinitionKey(null);
            HistoricDecisionInstanceQueryTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByCaseDefinitionId() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionId(caseInstance.getCaseDefinitionId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByInvalidCaseDefinitionId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionId("invalid").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.caseDefinitionId(null);
            HistoricDecisionInstanceQueryTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByCaseInstanceId() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseInstanceId(caseInstance.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByInvalidCaseInstanceId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseInstanceId("invalid").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.caseInstanceId(null);
            HistoricDecisionInstanceQueryTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByUserId() {
        this.evaluateDecisionWithAuthenticatedUser("demo");
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.userId("demo").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByInvalidUserId() {
        this.evaluateDecisionWithAuthenticatedUser("demo");
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.userId("dem1").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.userId(null);
            HistoricDecisionInstanceQueryTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByRootDecisionInstanceId() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        String rootDecisionInstanceId = ((HistoricDecisionInstance)query.decisionDefinitionKey(DISH_DECISION).singleResult()).getId();
        String requiredDecisionInstanceId1 = ((HistoricDecisionInstance)query.decisionDefinitionKey("season").singleResult()).getId();
        String requiredDecisionInstanceId2 = ((HistoricDecisionInstance)query.decisionDefinitionKey("guestCount").singleResult()).getId();
        query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.rootDecisionInstanceId(rootDecisionInstanceId).count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.rootDecisionInstanceId(requiredDecisionInstanceId1).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.rootDecisionInstanceId(requiredDecisionInstanceId2).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByRootDecisionInstancesOnly() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.rootDecisionInstancesOnly().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((HistoricDecisionInstance)query.rootDecisionInstancesOnly().singleResult()).getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DISH_DECISION));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByDecisionRequirementsDefinitionId() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionId("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionId(decisionRequirementsDefinition.getId()).count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testQueryByDecisionRequirementsDefinitionKey() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKey("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKey("dish").count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testNativeQuery() {
        this.startProcessInstanceAndEvaluateDecision();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM " + tablePrefix + "ACT_HI_DECINST");
        Assert.assertThat((Object)nativeQuery.list().size(), (Matcher)CoreMatchers.is((Object)1));
        NativeHistoricDecisionInstanceQuery nativeQueryWithParameter = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM " + tablePrefix + "ACT_HI_DECINST H WHERE H.DEC_DEF_KEY_ = #{decisionDefinitionKey}");
        Assert.assertThat((Object)((NativeHistoricDecisionInstanceQuery)nativeQueryWithParameter.parameter("decisionDefinitionKey", (Object)DECISION_DEFINITION_KEY)).list().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((NativeHistoricDecisionInstanceQuery)nativeQueryWithParameter.parameter("decisionDefinitionKey", (Object)"other decision")).list().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testNativeCountQuery() {
        this.startProcessInstanceAndEvaluateDecision();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT count(*) FROM " + tablePrefix + "ACT_HI_DECINST");
        Assert.assertThat((Object)nativeQuery.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testNativeQueryPaging() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecision();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM " + tablePrefix + "ACT_HI_DECINST");
        Assert.assertThat((Object)nativeQuery.listPage(0, 2).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)nativeQuery.listPage(1, 1).size(), (Matcher)CoreMatchers.is((Object)1));
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision() {
        return this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.getVariables());
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecisionWithUnderscore() {
        return this.runtimeService.startProcessInstanceByKey("testProcess_", (Map)this.getVariables());
    }

    protected CaseInstance createCaseInstanceAndEvaluateDecision() {
        return this.caseService.withCaseDefinitionByKey("case").setVariables((Map)this.getVariables()).create();
    }

    protected void evaluateDecisionWithAuthenticatedUser(String userId) {
        this.identityService.setAuthenticatedUserId(userId);
        VariableMap variables = Variables.putValue((String)"input1", (Object)"test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)variables);
    }

    protected VariableMap getVariables() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", (Object)"test");
        return variables;
    }

    protected void waitASignificantAmountOfTime() {
        DateTime now = new DateTime((Object)ClockUtil.getCurrentTime());
        ClockUtil.setCurrentTime((Date)now.plusSeconds(10).toDate());
    }
}

