/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.entity;

import java.util.ArrayList;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExecutionEntityTest {
    @Rule
    public ProcessEngineRule processEngineRule = new ProcessEngineRule(true);
    @Rule
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testRestoreProcessInstance() {
        ArrayList<ExecutionEntity> entities = new ArrayList<ExecutionEntity>();
        ExecutionEntity parent = new ExecutionEntity();
        parent.setId("parent");
        entities.add(parent);
        parent.restoreProcessInstance(entities, null, null, null, null, null, null);
        ExecutionEntity entity = new ExecutionEntity();
        entity.setId("child");
        entity.setParentId(parent.getId());
        entities.add(entity);
        parent.restoreProcessInstance(entities, null, null, null, null, null, null);
        entities.remove(parent);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot resolve parent with id 'parent' of execution 'child', perhaps it was deleted in the meantime");
        parent.restoreProcessInstance(entities, null, null, null, null, null, null);
    }

    @Test
    public void testRemoveExecutionSequence() {
        BpmnModelInstance modelInstance = ((BoundaryEventBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"singleTaskProcess").startEvent().userTask("taskWithLocalVariables").camundaExecutionListenerClass("start", TestLocalVariableExecutionListener.class)).camundaTaskListenerClass("delete", TestLocalVariableTaskListener.class)).boundaryEvent().signal("interruptSignal")).endEvent().moveToActivity("taskWithLocalVariables").endEvent().done();
        this.testRule.deploy(modelInstance);
        ProcessInstance pi = this.processEngineRule.getRuntimeService().startProcessInstanceByKey("singleTaskProcess");
        Execution execution = (Execution)this.processEngineRule.getRuntimeService().createExecutionQuery().variableValueEquals("localVar", (Object)"localVarVal").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)pi.getId(), (Object)execution.getProcessInstanceId());
        this.processEngineRule.getRuntimeService().signal(execution.getId());
    }

    public static class TestLocalVariableTaskListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            try {
                StringValue var = (StringValue)delegateTask.getExecution().getVariableLocalTyped("localVar");
                Assert.assertEquals((Object)"localVarVal", (Object)var.getValue());
            }
            catch (NullPointerException e) {
                Assert.fail((String)"Local variable shouldn't be null.");
            }
        }
    }

    public static class TestLocalVariableExecutionListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            execution.setVariableLocal("localVar", (Object)"localVarVal");
        }
    }
}

