/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobsRetriesBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class SetJobsRetriesByProcessBatchCmd
extends AbstractSetJobsRetriesBatchCmd {
    protected final List<String> processInstanceIds;
    protected final ProcessInstanceQuery query;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;

    public SetJobsRetriesByProcessBatchCmd(List<String> processInstanceIds, ProcessInstanceQuery query, HistoricProcessInstanceQuery historicProcessInstanceQuery, int retries) {
        this.processInstanceIds = processInstanceIds;
        this.query = query;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.retries = retries;
    }

    @Override
    protected List<String> collectJobIds(CommandContext commandContext) {
        ArrayList<String> collectedJobIds = new ArrayList<String>();
        ArrayList<String> collectedProcessInstanceIds = new ArrayList<String>();
        if (this.query != null) {
            collectedProcessInstanceIds.addAll(((ProcessInstanceQueryImpl)this.query).listIds());
        }
        if (this.historicProcessInstanceQuery != null) {
            List<String> ids = ((HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery).listIds();
            collectedProcessInstanceIds.addAll(ids);
        }
        if (this.processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(this.processInstanceIds);
        }
        for (String process : collectedProcessInstanceIds) {
            for (Job job : commandContext.getJobManager().findJobsByProcessInstanceId(process)) {
                collectedJobIds.add(job.getId());
            }
        }
        return collectedJobIds;
    }
}

