/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricDecisionInstancesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricDecisionInstancesCmd
implements Command<Batch> {
    protected SetRemovalTimeToHistoricDecisionInstancesBuilderImpl builder;

    public SetRemovalTimeToHistoricDecisionInstancesCmd(SetRemovalTimeToHistoricDecisionInstancesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        HashSet<String> collectedInstanceIds = new HashSet<String>();
        List<String> instanceIds = this.builder.getIds();
        HistoricDecisionInstanceQuery instanceQuery = this.builder.getQuery();
        if (instanceQuery == null && instanceIds == null) {
            throw new BadUserRequestException("Neither query nor ids provided.");
        }
        if (instanceQuery != null) {
            for (HistoricDecisionInstance historicDecisionInstance : instanceQuery.list()) {
                collectedInstanceIds.add(historicDecisionInstance.getId());
            }
        }
        if (instanceIds != null) {
            collectedInstanceIds.addAll(this.findHistoricInstanceIds(instanceIds, commandContext));
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicDecisionInstances", collectedInstanceIds);
        return new BatchBuilder(commandContext).type("decision-set-removal-time").config(this.getConfiguration(collectedInstanceIds)).permission(BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected List<String> findHistoricInstanceIds(List<String> instanceIds, CommandContext commandContext) {
        List historicDecisionInstances = this.createHistoricDecisionInstanceQuery(commandContext).decisionInstanceIdIn(instanceIds.toArray(new String[0])).list();
        ArrayList<String> ids = new ArrayList<String>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            ids.add(historicDecisionInstance.getId());
        }
        return ids;
    }

    protected HistoricDecisionInstanceQuery createHistoricDecisionInstanceQuery(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricDecisionInstanceQuery();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)this.builder.getMode()));
        propertyChanges.add(new PropertyChange("removalTime", null, this.builder.getRemovalTime()));
        propertyChanges.add(new PropertyChange("hierarchical", null, this.builder.isHierarchical()));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("SetRemovalTime", propertyChanges);
    }

    protected boolean hasRemovalTime() {
        return this.builder.getMode() == SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    public BatchConfiguration getConfiguration(Collection<String> instances) {
        return new SetRemovalTimeBatchConfiguration(new ArrayList<String>(instances)).setHierarchical(this.builder.isHierarchical()).setHasRemovalTime(this.hasRemovalTime()).setRemovalTime(this.builder.getRemovalTime());
    }
}

