/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricProcessInstancesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricProcessInstancesCmd
implements Command<Batch> {
    protected SetRemovalTimeToHistoricProcessInstancesBuilderImpl builder;

    public SetRemovalTimeToHistoricProcessInstancesCmd(SetRemovalTimeToHistoricProcessInstancesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> instanceIds = this.builder.getIds();
        HistoricProcessInstanceQuery instanceQuery = this.builder.getQuery();
        if (instanceQuery == null && instanceIds == null) {
            throw new BadUserRequestException("Neither query nor ids provided.");
        }
        HashSet<String> collectedInstanceIds = new HashSet<String>();
        if (instanceQuery != null) {
            for (HistoricProcessInstance historicDecisionInstance : instanceQuery.list()) {
                collectedInstanceIds.add(historicDecisionInstance.getId());
            }
        }
        if (instanceIds != null) {
            collectedInstanceIds.addAll(this.findHistoricInstanceIds(instanceIds, commandContext));
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicProcessInstances", collectedInstanceIds);
        return new BatchBuilder(commandContext).type("process-set-removal-time").config(this.getConfiguration(collectedInstanceIds)).permission(BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected List<String> findHistoricInstanceIds(List<String> instanceIds, CommandContext commandContext) {
        List historicProcessInstances = this.createHistoricDecisionInstanceQuery(commandContext).processInstanceIds(new HashSet<String>(instanceIds)).list();
        ArrayList<String> ids = new ArrayList<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            ids.add(historicProcessInstance.getId());
        }
        return ids;
    }

    protected HistoricProcessInstanceQuery createHistoricDecisionInstanceQuery(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricProcessInstanceQuery();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)this.builder.getMode()));
        propertyChanges.add(new PropertyChange("removalTime", null, this.builder.getRemovalTime()));
        propertyChanges.add(new PropertyChange("hierarchical", null, this.builder.isHierarchical()));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logProcessInstanceOperation("SetRemovalTime", propertyChanges);
    }

    protected boolean hasRemovalTime() {
        return this.builder.getMode() == SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    public BatchConfiguration getConfiguration(Collection<String> instanceIds) {
        return new SetRemovalTimeBatchConfiguration(new ArrayList<String>(instanceIds)).setHierarchical(this.builder.isHierarchical()).setHasRemovalTime(this.hasRemovalTime()).setRemovalTime(this.builder.getRemovalTime());
    }
}

