/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceMilestoneTest
extends PluggableProcessEngineTestCase {
    protected final String DEFINITION_KEY = "oneMilestoneCase";
    protected final String MILESTONE_KEY = "PI_Milestone_1";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneMilestoneCase.cmmn"})
    public void testManualStart() {
        this.createCaseInstance("oneMilestoneCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).manualStart();
            CaseServiceMilestoneTest.fail();
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneMilestoneCase.cmmn"})
    public void testDisable() {
        this.createCaseInstance("oneMilestoneCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).disable();
            CaseServiceMilestoneTest.fail();
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneMilestoneCase.cmmn"})
    public void testReenable() {
        this.createCaseInstance("oneMilestoneCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).reenable();
            CaseServiceMilestoneTest.fail();
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneMilestoneCase.cmmn"})
    public void testComplete() {
        this.createCaseInstance("oneMilestoneCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            CaseServiceMilestoneTest.fail();
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneMilestoneCase.cmmn"})
    public void testTerminate() {
        this.createCaseInstance("oneMilestoneCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        this.caseService.withCaseExecution(caseTaskId).terminate();
        CaseExecution caseMilestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        CaseServiceMilestoneTest.assertNull((Object)caseMilestone);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneMilestoneCase.cmmn"})
    public void testTerminateNonFluent() {
        this.createCaseInstance("oneMilestoneCase").getId();
        CaseExecution caseMilestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        CaseServiceMilestoneTest.assertNotNull((Object)caseMilestone);
        this.caseService.terminateCaseExecution(caseMilestone.getId());
        caseMilestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        CaseServiceMilestoneTest.assertNull((Object)caseMilestone);
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected CaseInstance queryCaseInstanceByKey(String caseDefinitionKey) {
        return (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(caseDefinitionKey).singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }
}

