/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class FilterPropertiesTest
extends PluggableProcessEngineTestCase {
    protected Filter filter;
    protected String nestedJsonObject = "{\"id\":\"nested\"}";
    protected String nestedJsonArray = "[\"a\",\"b\"]";

    public void setUp() {
        this.filter = this.filterService.newTaskFilter("name").setOwner("owner").setProperties(new HashMap());
    }

    protected void tearDown() throws Exception {
        if (this.filter.getId() != null) {
            this.filterService.deleteFilter(this.filter.getId());
        }
    }

    public void testPropertiesFromNull() {
        this.filter.setProperties(null);
        FilterPropertiesTest.assertNull((Object)this.filter.getProperties());
        this.filter.setProperties((Map)null);
        FilterPropertiesTest.assertNull((Object)this.filter.getProperties());
    }

    public void testPropertiesFromMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("color", "#123456");
        properties.put("priority", 42);
        properties.put("userDefined", true);
        properties.put("object", this.nestedJsonObject);
        properties.put("array", this.nestedJsonArray);
        this.filter.setProperties(properties);
        this.assertTestProperties();
    }

    protected void assertTestProperties() {
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map properties = this.filter.getProperties();
        FilterPropertiesTest.assertEquals((int)5, (int)properties.size());
        FilterPropertiesTest.assertEquals((Object)"#123456", properties.get("color"));
        FilterPropertiesTest.assertEquals((Object)42, properties.get("priority"));
        FilterPropertiesTest.assertEquals((Object)true, properties.get("userDefined"));
        FilterPropertiesTest.assertEquals((Object)this.nestedJsonObject, properties.get("object"));
        FilterPropertiesTest.assertEquals((Object)this.nestedJsonArray, properties.get("array"));
    }

    public void testNullProperty() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("null", null);
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map persistentProperties = this.filter.getProperties();
        FilterPropertiesTest.assertEquals((int)1, (int)persistentProperties.size());
        FilterPropertiesTest.assertTrue((boolean)persistentProperties.containsKey("null"));
        FilterPropertiesTest.assertNull(persistentProperties.get("null"));
    }

    public void testMapContainingListProperty() {
        Map<String, List<String>> properties = Collections.singletonMap("foo", Collections.singletonList("bar"));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        List list = (List)deserialisedProperties.get("foo");
        Object string = list.get(0);
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(string, (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)string.toString(), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    public void testMapContainingMapProperty() {
        Map<String, Map<String, String>> properties = Collections.singletonMap("foo", Collections.singletonMap("bar", "foo"));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        Map map = (Map)deserialisedProperties.get("foo");
        Object string = map.get("bar");
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)string.toString(), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    public void testMapContainingMapContainingListProperty() {
        Map<String, Map<String, List<String>>> properties = Collections.singletonMap("foo", Collections.singletonMap("bar", Collections.singletonList("foo")));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        Map map = (Map)deserialisedProperties.get("foo");
        List list = (List)map.get("bar");
        Object string = list.get(0);
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)string.toString(), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    public void testMapContainingListContainingMapProperty_DeserializePrimitives() {
        HashMap<String, Object> primitives = new HashMap<String, Object>();
        primitives.put("string", "aStringValue");
        primitives.put("int", 47);
        primitives.put("intOutOfRange", 0x80000000L);
        primitives.put("long", Long.MAX_VALUE);
        primitives.put("double", 3.14159265359);
        primitives.put("boolean", true);
        primitives.put("null", null);
        Map properties = Collections.singletonMap("foo", Collections.singletonList(primitives));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        List list = (List)deserialisedProperties.get("foo");
        Map map = (Map)list.get(0);
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)map.get("string")), (Matcher)CoreMatchers.is((Object)"aStringValue"));
        MatcherAssert.assertThat((Object)((Integer)map.get("int")), (Matcher)CoreMatchers.is((Object)47));
        MatcherAssert.assertThat((Object)((Long)map.get("intOutOfRange")), (Matcher)CoreMatchers.is((Object)0x80000000L));
        MatcherAssert.assertThat((Object)((Long)map.get("long")), (Matcher)CoreMatchers.is((Object)Long.MAX_VALUE));
        MatcherAssert.assertThat((Object)((Double)map.get("double")), (Matcher)CoreMatchers.is((Object)3.14159265359));
        MatcherAssert.assertThat((Object)((Boolean)map.get("boolean")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(map.get("null"), (Matcher)CoreMatchers.nullValue());
    }

    public void testMapContainingMapContainingListProperty_DeserializePrimitives() {
        ArrayList<Object> primitives = new ArrayList<Object>();
        primitives.add("aStringValue");
        primitives.add(47);
        primitives.add(0x80000000L);
        primitives.add(Long.MAX_VALUE);
        primitives.add(3.14159265359);
        primitives.add(true);
        primitives.add(null);
        Map properties = Collections.singletonMap("foo", Collections.singletonMap("bar", primitives));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        List list = (List)((Map)deserialisedProperties.get("foo")).get("bar");
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)list.get(0)), (Matcher)CoreMatchers.is((Object)"aStringValue"));
        MatcherAssert.assertThat((Object)((Integer)list.get(1)), (Matcher)CoreMatchers.is((Object)47));
        MatcherAssert.assertThat((Object)((Long)list.get(2)), (Matcher)CoreMatchers.is((Object)0x80000000L));
        MatcherAssert.assertThat((Object)((Long)list.get(3)), (Matcher)CoreMatchers.is((Object)Long.MAX_VALUE));
        MatcherAssert.assertThat((Object)((Double)list.get(4)), (Matcher)CoreMatchers.is((Object)3.14159265359));
        MatcherAssert.assertThat((Object)((Boolean)list.get(5)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(list.get(6), (Matcher)CoreMatchers.nullValue());
    }
}

