/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class HistoryServiceAsyncOperationsTest
extends AbstractAsyncOperationsTest {
    protected static final String TEST_REASON = "test reason";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected TaskService taskService;
    protected List<String> historicProcessInstances;

    @Override
    @Before
    public void initServices() {
        super.initServices();
        this.taskService = this.engineRule.getTaskService();
        this.prepareData();
    }

    public void prepareData() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.startTestProcesses(2);
        for (Task activeTask : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(activeTask.getId());
        }
        this.historicProcessInstances = new ArrayList<String>();
        for (HistoricProcessInstance pi : this.historyService.createHistoricProcessInstanceQuery().list()) {
            this.historicProcessInstances.add(pi.getId());
        }
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult()) != null) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithList() throws Exception {
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, TEST_REASON);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithEmptyList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.historyService.deleteHistoricProcessInstancesAsync(new ArrayList(), TEST_REASON);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithFake() throws Exception {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        processInstanceIds.add(this.historicProcessInstances.get(0));
        processInstanceIds.add("aFakeId");
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(processInstanceIds, TEST_REASON);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithQueryAndList() throws Exception {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.historicProcessInstances.get(0));
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances.subList(1, this.historicProcessInstances.size()), query, TEST_REASON);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithQuery() throws Exception {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet<String>(this.historicProcessInstances));
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(query, TEST_REASON);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithEmptyQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().unfinished();
        this.historyService.deleteHistoricProcessInstancesAsync(query, TEST_REASON);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithNonExistingIDAsQuery() throws Exception {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        processInstanceIds.add(this.historicProcessInstances.get(0));
        processInstanceIds.add("aFakeId");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(processInstanceIds));
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(query, TEST_REASON);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithoutDeleteReason() throws Exception {
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, null);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithNullList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.historyService.deleteHistoricProcessInstancesAsync((List)null, TEST_REASON);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithNullQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.historyService.deleteHistoricProcessInstancesAsync((HistoricProcessInstanceQuery)null, TEST_REASON);
    }

    @Test
    public void shouldSetInvocationsPerBatchType() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("historic-instance-deletion", 42);
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, TEST_REASON);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    protected void assertNoHistoryForTasks() {
        if (!this.testRule.isHistoryLevelNone()) {
            Assert.assertThat((Object)this.historyService.createHistoricTaskInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        }
    }

    protected void assertAllHistoricProcessInstancesAreDeleted() {
        MatcherAssert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)Is.is((Object)0L));
    }
}

