/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.apache.commons.lang3.tuple.Triple;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class IdentityServiceUserOperationLogTest {
    protected static final String TEST_USER_ID = "newTestUser";
    protected static final String TEST_GROUP_ID = "newTestGroup";
    protected static final String TEST_TENANT_ID = "newTestTenant";
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected UserOperationLogQuery query;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.historyService = this.engineRule.getHistoryService();
        this.query = this.historyService.createUserOperationLogQuery();
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Tenant tenant : this.identityService.createTenantQuery().list()) {
            this.identityService.deleteTenant(tenant.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void shouldLogUserCreation() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.clearAuthentication();
        this.assertLog("Create", "User", null, TEST_USER_ID);
    }

    @Test
    public void shouldNotLogUserCreationFailure() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogUserUpdate() {
        User newUser = this.identityService.newUser(TEST_USER_ID);
        this.identityService.saveUser(newUser);
        Assert.assertEquals((long)0L, (long)this.query.count());
        newUser.setEmail("test@mail.com");
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.saveUser(newUser);
        this.identityService.clearAuthentication();
        this.assertLog("Update", "User", null, TEST_USER_ID);
    }

    @Test
    public void shouldLogUserDeletion() {
        User newUser = this.identityService.newUser(TEST_USER_ID);
        this.identityService.saveUser(newUser);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteUser(newUser.getId());
        this.identityService.clearAuthentication();
        this.assertLog("Delete", "User", null, TEST_USER_ID);
    }

    @Test
    public void shouldNotLogUserDeletionOnNonExisting() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteUser(TEST_USER_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogUserUnlock() {
        User newUser = this.identityService.newUser(TEST_USER_ID);
        newUser.setPassword("right");
        this.identityService.saveUser(newUser);
        this.identityService.checkPassword(TEST_USER_ID, "wrong!");
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.unlockUser(TEST_USER_ID);
        this.identityService.clearAuthentication();
        this.assertLog("Unlock", "User", null, TEST_USER_ID);
    }

    @Test
    public void shouldNotLogUserUnlockOnNonExistingUser() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.unlockUser(TEST_USER_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldNotLogUserUnlockOnNonExistingLock() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.unlockUser(TEST_USER_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogGroupCreation() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        this.identityService.clearAuthentication();
        this.assertLog("Create", "Group", null, TEST_GROUP_ID);
    }

    @Test
    public void shouldNotLogGroupCreationFailure() {
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogGroupUpdate() {
        Group newGroup = this.identityService.newGroup(TEST_GROUP_ID);
        this.identityService.saveGroup(newGroup);
        Assert.assertEquals((long)0L, (long)this.query.count());
        newGroup.setName("testName");
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.saveGroup(newGroup);
        this.identityService.clearAuthentication();
        this.assertLog("Update", "Group", null, TEST_GROUP_ID);
    }

    @Test
    public void shouldLogGroupDeletion() {
        Group newGroup = this.identityService.newGroup(TEST_GROUP_ID);
        this.identityService.saveGroup(newGroup);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteGroup(newGroup.getId());
        this.identityService.clearAuthentication();
        this.assertLog("Delete", "Group", null, TEST_GROUP_ID);
    }

    @Test
    public void shouldNotLogGroupDeletionOnNonExisting() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteGroup(TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogTenantCreation() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        this.identityService.clearAuthentication();
        this.assertLog("Create", "Tenant", null, TEST_TENANT_ID);
    }

    @Test
    public void shouldNotLogTenantCreationFailure() {
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogTenantUpdate() {
        Tenant newTenant = this.identityService.newTenant(TEST_TENANT_ID);
        this.identityService.saveTenant(newTenant);
        Assert.assertEquals((long)0L, (long)this.query.count());
        newTenant.setName("testName");
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.saveTenant(newTenant);
        this.identityService.clearAuthentication();
        this.assertLog("Update", "Tenant", null, TEST_TENANT_ID);
    }

    @Test
    public void shouldLogTenantDeletion() {
        Tenant newTenant = this.identityService.newTenant(TEST_TENANT_ID);
        this.identityService.saveTenant(newTenant);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteTenant(newTenant.getId());
        this.identityService.clearAuthentication();
        this.assertLog("Delete", "Tenant", null, TEST_TENANT_ID);
    }

    @Test
    public void shouldNotLogTenantDeletionOnNonExisting() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteTenant(TEST_TENANT_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogGroupMembershipCreation() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.createMembership(TEST_USER_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        this.assertLogs("Create", "Group membership", Triple.of((Object)"userId", (Object)null, (Object)TEST_USER_ID), Triple.of((Object)"groupId", (Object)null, (Object)TEST_GROUP_ID));
    }

    @Test
    public void shouldNotLogGroupMembershipCreationFailure() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        this.identityService.createMembership(TEST_USER_ID, TEST_GROUP_ID);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createMembership(TEST_USER_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogGroupMembershipDeletion() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        this.identityService.createMembership(TEST_USER_ID, TEST_GROUP_ID);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteMembership(TEST_USER_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        this.assertLogs("Delete", "Group membership", Triple.of((Object)"userId", (Object)null, (Object)TEST_USER_ID), Triple.of((Object)"groupId", (Object)null, (Object)TEST_GROUP_ID));
    }

    @Test
    public void shouldNotLogGroupMembershipDeletionOnNonExisting() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteMembership(TEST_USER_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogTenantUserMembershipCreation() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.createTenantUserMembership(TEST_TENANT_ID, TEST_USER_ID);
        this.identityService.clearAuthentication();
        this.assertLogs("Create", "TenantMembership", Triple.of((Object)"userId", (Object)null, (Object)TEST_USER_ID), Triple.of((Object)"tenantId", (Object)null, (Object)TEST_TENANT_ID));
    }

    @Test
    public void shouldNotLogTenantUserMembershipCreationFailure() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        this.identityService.createTenantUserMembership(TEST_TENANT_ID, TEST_USER_ID);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createTenantUserMembership(TEST_TENANT_ID, TEST_USER_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogTenantUserMembershipDeletion() {
        this.identityService.saveUser(this.identityService.newUser(TEST_USER_ID));
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        this.identityService.createTenantUserMembership(TEST_TENANT_ID, TEST_USER_ID);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteTenantUserMembership(TEST_TENANT_ID, TEST_USER_ID);
        this.identityService.clearAuthentication();
        this.assertLogs("Delete", "TenantMembership", Triple.of((Object)"userId", (Object)null, (Object)TEST_USER_ID), Triple.of((Object)"tenantId", (Object)null, (Object)TEST_TENANT_ID));
    }

    @Test
    public void shouldNotLogTenantUserMembershipDeletionOnNonExisting() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteTenantUserMembership(TEST_TENANT_ID, TEST_USER_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogTenantGroupMembershipCreation() {
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.createTenantGroupMembership(TEST_TENANT_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        this.assertLogs("Create", "TenantMembership", Triple.of((Object)"groupId", (Object)null, (Object)TEST_GROUP_ID), Triple.of((Object)"tenantId", (Object)null, (Object)TEST_TENANT_ID));
    }

    @Test
    public void shouldNotLogTenantGroupMembershipCreationFailure() {
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        this.identityService.createTenantGroupMembership(TEST_TENANT_ID, TEST_GROUP_ID);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createTenantGroupMembership(TEST_TENANT_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    @Test
    public void shouldLogTenantGroupMembershipDeletion() {
        this.identityService.saveGroup(this.identityService.newGroup(TEST_GROUP_ID));
        this.identityService.saveTenant(this.identityService.newTenant(TEST_TENANT_ID));
        this.identityService.createTenantGroupMembership(TEST_TENANT_ID, TEST_GROUP_ID);
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteTenantGroupMembership(TEST_TENANT_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        this.assertLogs("Delete", "TenantMembership", Triple.of((Object)"groupId", (Object)null, (Object)TEST_GROUP_ID), Triple.of((Object)"tenantId", (Object)null, (Object)TEST_TENANT_ID));
    }

    @Test
    public void shouldNotLogTenantGroupMembershipDeletionOnNonExisting() {
        Assert.assertEquals((long)0L, (long)this.query.count());
        this.identityService.setAuthenticatedUserId("userId");
        this.identityService.deleteTenantGroupMembership(TEST_TENANT_ID, TEST_GROUP_ID);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.query.count());
    }

    protected void assertLog(String operation, String entity, String orgValue, String newValue) {
        Assert.assertEquals((long)1L, (long)this.query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)this.query.singleResult();
        Assert.assertEquals((Object)operation, (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)entity, (Object)entry.getEntityType());
        Assert.assertEquals((Object)orgValue, (Object)entry.getOrgValue());
        Assert.assertEquals((Object)newValue, (Object)entry.getNewValue());
    }

    @SafeVarargs
    protected final void assertLogs(String operation, String entity, Triple<String, String, String> ... values) {
        Assert.assertEquals((long)values.length, (long)this.query.count());
        for (Triple<String, String, String> valueTriple : values) {
            UserOperationLogEntry entry = (UserOperationLogEntry)this.query.property((String)valueTriple.getLeft()).singleResult();
            Assert.assertEquals((Object)operation, (Object)entry.getOperationType());
            Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
            Assert.assertEquals((Object)entity, (Object)entry.getEntityType());
            Assert.assertEquals((Object)valueTriple.getMiddle(), (Object)entry.getOrgValue());
            Assert.assertEquals((Object)valueTriple.getRight(), (Object)entry.getNewValue());
        }
    }
}

