/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ManagementServiceAsyncOperationsTest
extends AbstractAsyncOperationsTest {
    protected static final int RETRIES = 5;
    protected static final String TEST_PROCESS = "exceptionInJobExecution";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected List<String> processInstanceIds;
    protected List<String> ids;

    @Override
    @Before
    public void initServices() {
        super.initServices();
        this.prepareData();
    }

    public void prepareData() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml");
        this.processInstanceIds = this.startTestProcesses(2);
        this.ids = this.getAllJobIds();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult()) != null) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    protected List<String> getAllJobIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (Job job : this.managementService.createJobQuery().list()) {
            if (job.getProcessInstanceId() == null) continue;
            result.add(job.getId());
        }
        return result;
    }

    @Override
    protected List<String> startTestProcesses(int numberOfProcesses) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < numberOfProcesses; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(TEST_PROCESS).getProcessInstanceId());
        }
        return ids;
    }

    protected void assertRetries(List<String> allJobIds, int i) {
        for (String id : allJobIds) {
            Assert.assertThat((Object)((Job)this.managementService.createJobQuery().jobId(id).singleResult()).getRetries(), (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void testSetJobsRetryAsyncWithJobList() throws Exception {
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void shouldSetInvocationsPerBatchTypeForJobsByJobIds() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("set-job-retries", 42);
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, 5);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    public void testSetJobsRetryAsyncWithProcessList() throws Exception {
        Batch batch = this.managementService.setJobRetriesAsync(this.processInstanceIds, (ProcessInstanceQuery)null, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyJobList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.managementService.setJobRetriesAsync(new ArrayList(), 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyProcessList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.managementService.setJobRetriesAsync(new ArrayList(), (ProcessInstanceQuery)null, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingJobID() throws Exception {
        this.ids.add("aFake");
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)1));
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingProcessID() throws Exception {
        this.processInstanceIds.add("aFake");
        Batch batch = this.managementService.setJobRetriesAsync(this.processInstanceIds, (ProcessInstanceQuery)null, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithJobQueryAndList() throws Exception {
        List<String> extraPi = this.startTestProcesses(1);
        JobQuery query = this.managementService.createJobQuery().processInstanceId(extraPi.get(0));
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, query, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithProcessQueryAndList() throws Exception {
        List<String> extraPi = this.startTestProcesses(1);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceId(extraPi.get(0));
        Batch batch = this.managementService.setJobRetriesAsync(this.processInstanceIds, query, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithJobQuery() throws Exception {
        JobQuery query = this.managementService.createJobQuery();
        Batch batch = this.managementService.setJobRetriesAsync(query, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithProcessQuery() throws Exception {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesAsync(null, query, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testSetJobsRetryAsyncWithHistoryProcessQuery() {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesAsync(null, null, historicProcessInstanceQuery, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testSetJobsRetryAsyncWithRuntimeAndHistoryProcessQuery() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceId(this.processInstanceIds.get(0));
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceIds.get(1));
        Batch batch = this.managementService.setJobRetriesAsync(null, query, historicProcessInstanceQuery, 5);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyJobQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        JobQuery query = this.managementService.createJobQuery().suspended();
        this.managementService.setJobRetriesAsync(query, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyProcessQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().suspended();
        this.managementService.setJobRetriesAsync(null, query, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingIDAsJobQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        JobQuery query = this.managementService.createJobQuery().jobId(this.ids.get(0)).jobId("aFake");
        this.managementService.setJobRetriesAsync(query, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingIDAsProcessQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceId("aFake");
        this.managementService.setJobRetriesAsync(null, query, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithNullJobList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.managementService.setJobRetriesAsync((List)null, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithNullJobQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.managementService.setJobRetriesAsync((JobQuery)null, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithNullProcessQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.managementService.setJobRetriesAsync(null, (ProcessInstanceQuery)null, 5);
    }

    @Test
    public void testSetJobsRetryAsyncWithNegativeRetries() throws Exception {
        JobQuery query = this.managementService.createJobQuery();
        this.thrown.expect(ProcessEngineException.class);
        this.managementService.setJobRetriesAsync(query, -1);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSetInvocationsPerBatchTypeForJobsByProcessInstanceIds() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("set-job-retries", 42);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesAsync(null, null, historicProcessInstanceQuery, 5);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }
}

