/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class ModificationUserOperationLogTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    protected BatchModificationHelper helper = new BatchModificationHelper(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected BpmnModelInstance instance;
    protected static final Date START_DATE = new Date(1457326800000L);

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.historyService = this.rule.getHistoryService();
        this.identityService = this.rule.getIdentityService();
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)START_DATE);
    }

    @Before
    public void createBpmnModelInstance() {
        this.instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").userTask("user1").sequenceFlowId("seq")).userTask("user2").endEvent("end").done();
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void removeInstanceIds() {
        this.helper.currentProcessInstances = new ArrayList<String>();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testLogCreation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        this.identityService.setAuthenticatedUserId("userId");
        this.helper.startBeforeAsync("process1", 10, "user2", processDefinition.getId());
        this.identityService.clearAuthentication();
        List opLogEntries = this.historyService.createUserOperationLogQuery().operationType("ModifyProcessInstance").list();
        Assert.assertEquals((long)2L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"ModifyProcessInstance", (Object)asyncEntry.getOperationType());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)asyncEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)processDefinition.getKey(), (Object)asyncEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)asyncEntry.getCategory());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)numInstancesEntry.getEntityType());
        Assert.assertEquals((Object)"ModifyProcessInstance", (Object)numInstancesEntry.getOperationType());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)numInstancesEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)processDefinition.getKey(), (Object)numInstancesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstancesEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstancesEntry.getOrgValue());
        Assert.assertEquals((Object)"10", (Object)numInstancesEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)numInstancesEntry.getCategory());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)numInstancesEntry.getOperationId());
    }

    @Test
    public void testNoCreationOnSyncBatchJobExecution() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startAfterActivity("user2")).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.helper.executeSeedJob(batch);
        this.identityService.setAuthenticatedUserId("userId");
        this.helper.executeJobs(batch);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().entityType("ProcessInstance").count());
    }

    @Test
    public void testNoCreationOnJobExecutorBatchJobExecution() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.createModification(processDefinition.getId()).cancelAllForActivity("user1").processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    @Test
    public void testBatchSyncModificationLogCreationWithAnnotation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.identityService.setAuthenticatedUserId("userId");
        String annotation = "cancelation due to error";
        this.runtimeService.createModification(processDefinition.getId()).cancelAllForActivity("user1").processInstanceIds(Arrays.asList(processInstance.getId())).setAnnotation(annotation).execute();
        this.identityService.clearAuthentication();
        List opLogEntries = this.historyService.createUserOperationLogQuery().operationType("ModifyProcessInstance").list();
        Assert.assertEquals((long)2L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)annotation, (Object)asyncEntry.getAnnotation());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)annotation, (Object)numInstancesEntry.getAnnotation());
    }

    @Test
    public void testBatchAsyncModificationLogCreationWithAnnotation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.identityService.setAuthenticatedUserId("userId");
        String annotation = "cancelation due to error";
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startAfterActivity("user1")).processInstanceIds(Arrays.asList(processInstance.getId())).setAnnotation(annotation).executeAsync();
        this.identityService.clearAuthentication();
        List opLogEntries = this.historyService.createUserOperationLogQuery().operationType("ModifyProcessInstance").list();
        Assert.assertEquals((long)2L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)annotation, (Object)asyncEntry.getAnnotation());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)annotation, (Object)numInstancesEntry.getAnnotation());
    }

    @Test
    public void testSyncModificationLogCreationWithAnnotation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.identityService.setAuthenticatedUserId("userId");
        String annotation = "cancelation due to error";
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("user1")).cancelAllForActivity("user1").setAnnotation(annotation).execute();
        this.identityService.clearAuthentication();
        List logs = this.historyService.createUserOperationLogQuery().operationType("ModifyProcessInstance").list();
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)annotation, (Object)((UserOperationLogEntry)logs.get(0)).getAnnotation());
    }

    @Test
    public void testAsyncModificationLogCreationWithAnnotation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.identityService.setAuthenticatedUserId("userId");
        String annotation = "cancelation due to error";
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance("user1").setAnnotation(annotation).executeAsync();
        this.identityService.clearAuthentication();
        List logs = this.historyService.createUserOperationLogQuery().operationType("ModifyProcessInstance").list();
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)annotation, (Object)((UserOperationLogEntry)logs.get(0)).getAnnotation());
    }

    @Test
    public void testModificationLogShouldNotIncludeEntryForTaskDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.identityService.setAuthenticatedUserId("userId");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("user1").execute();
        this.identityService.clearAuthentication();
        List logs = this.historyService.createUserOperationLogQuery().list();
        Assert.assertEquals((long)1L, (long)logs.size());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)logs.get(0);
        Assertions.assertThat((String)userOperationLogEntry.getEntityType()).isEqualTo((Object)"ProcessInstance");
        Assertions.assertThat((String)userOperationLogEntry.getOperationType()).isEqualTo((Object)"ModifyProcessInstance");
    }

    protected Map<String, UserOperationLogEntry> asMap(List<UserOperationLogEntry> logEntries) {
        HashMap<String, UserOperationLogEntry> map = new HashMap<String, UserOperationLogEntry>();
        for (UserOperationLogEntry entry : logEntries) {
            UserOperationLogEntry previousValue = map.put(entry.getProperty(), entry);
            if (previousValue == null) continue;
            Assert.fail((String)"expected only entry for every property");
        }
        return map;
    }
}

