/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class ProcessInstanceTerminationCascadeStateTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngine engine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected boolean externallyTerminated;

    @Before
    public void init() {
        this.engine = this.engineRule.getProcessEngine();
        this.repositoryService = this.engine.getRepositoryService();
        this.runtimeService = this.engine.getRuntimeService();
        this.historyService = this.engine.getHistoryService();
        this.prepareDeployment();
    }

    protected void prepareDeployment() {
        BpmnModelInstance callee = Bpmn.createExecutableProcess((String)"subProcess").startEvent().userTask("userTask").endEvent().done();
        BpmnModelInstance caller = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().callActivity("callActivity").calledElement("subProcess")).endEvent().done();
        this.testRule.deploy(caller, callee);
    }

    @After
    public void teardown() {
        List processes = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance historicProcessInstance : processes) {
            this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId());
        }
    }

    @Test
    public void shouldCascadeStateFromSubprocessUpDeletion() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance subProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess").singleResult();
        this.externallyTerminated = true;
        this.runtimeService.deleteProcessInstance(subProcess.getId(), "test", false, this.externallyTerminated);
        this.assertHistoricProcessInstances();
    }

    @Test
    public void shouldNotCascadeStateFromSubprocessUpDeletion() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance subProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess").singleResult();
        this.externallyTerminated = false;
        this.runtimeService.deleteProcessInstance(subProcess.getId(), "test", false, this.externallyTerminated);
        this.assertHistoricProcessInstances();
    }

    @Test
    public void shouldCascadeStateFromProcessDownDeletion() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        this.externallyTerminated = true;
        this.runtimeService.deleteProcessInstance(process.getId(), "test", false, this.externallyTerminated);
        this.assertHistoricProcessInstances();
    }

    @Test
    public void shouldNotCascadeStateFromProcessDownDeletion() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        this.externallyTerminated = false;
        this.runtimeService.deleteProcessInstance(process.getId(), "test", false, this.externallyTerminated);
        this.assertHistoricProcessInstances();
    }

    @Test
    public void shouldNotCascadeStateFromSubprocessUpCancelation() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance subProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess").singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(subProcess.getId());
        this.externallyTerminated = false;
        this.runtimeService.createProcessInstanceModification(subProcess.getId()).cancellationSourceExternal(this.externallyTerminated).cancelActivityInstance(activityInstance.getId()).execute();
        this.assertHistoricProcessInstances();
    }

    @Test
    public void shouldNotCascadeStateFromProcessDownCancelation() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(process.getId());
        this.externallyTerminated = false;
        this.runtimeService.createProcessInstanceModification(process.getId()).cancellationSourceExternal(this.externallyTerminated).cancelActivityInstance(activityInstance.getId()).execute();
        this.assertHistoricProcessInstances();
    }

    @Test
    public void shouldCascadeStateFromSubprocessUpCancelation() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance subProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess").singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(subProcess.getId());
        this.externallyTerminated = true;
        this.runtimeService.createProcessInstanceModification(subProcess.getId()).cancellationSourceExternal(this.externallyTerminated).cancelActivityInstance(activityInstance.getId()).execute();
        this.assertHistoricProcessInstances();
    }

    @Test
    public void shouldCascadeStateFromProcessDownCancelation() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(process.getId());
        this.externallyTerminated = true;
        this.runtimeService.createProcessInstanceModification(process.getId()).cancellationSourceExternal(this.externallyTerminated).cancelActivityInstance(activityInstance.getId()).execute();
        this.assertHistoricProcessInstances();
    }

    protected void assertHistoricProcessInstances() {
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((int)historicProcessInstances.size()).isEqualTo(2);
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            Assertions.assertThat((String)historicProcessInstance.getState()).isEqualTo((Object)(this.externallyTerminated ? "EXTERNALLY_TERMINATED" : "INTERNALLY_TERMINATED"));
        }
    }
}

