/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchSuspensionHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.python.google.common.collect.Sets;

public class UpdateProcessInstancesSuspendStateAsyncTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSuspensionHelper helper = new BatchSuspensionHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchSuspensionById() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void shouldSetInvocationsPerBatchTypeOnSuspension() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("instance-update-suspension-state", 42);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch batch = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void shouldSetInvocationsPerBatchTypeOnActivation() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("instance-update-suspension-state", 42);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch batch = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).activateAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchActivationById() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        Batch activateprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).activateAsync();
        this.helper.executeSeedJob(activateprocess);
        this.helper.executeJobs(activateprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchSuspensionByProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().active()).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchActivationByProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().active()).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        Batch activateprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().suspended()).activateAsync();
        this.helper.executeSeedJob(activateprocess);
        this.helper.executeJobs(activateprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="activity")
    public void testBatchSuspensionByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="activity")
    public void testBatchActivationByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        Batch activateprocess = this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).activateAsync();
        this.helper.executeSeedJob(activateprocess);
        this.helper.executeJobs(activateprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    public void testEmptyProcessInstanceListSuspendAsync() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("No process instance ids given");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[0]).suspendAsync();
    }

    @Test
    public void testEmptyProcessInstanceListActivateAsync() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("No process instance ids given");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[0]).activateAsync();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testNullProcessInstanceListActivateAsync() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Cannot be null");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId(), null)).activateAsync();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testNullProcessInstanceListSuspendAsync() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Cannot be null");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId(), null)).suspendAsync();
    }
}

