/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.CandidateDeployment;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentHandler;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;

public class VersionedDeploymentHandler
implements DeploymentHandler {
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected String candidateVersionTag;
    protected String candidateProcessDefinitionKey;

    public VersionedDeploymentHandler(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.repositoryService = processEngine.getRepositoryService();
    }

    public boolean shouldDeployResource(Resource newResource, Resource existingResource) {
        if (this.isBpmnResource(newResource)) {
            Integer existingVersion = this.parseCamundaVersionTag(existingResource);
            Integer newVersion = this.parseCamundaVersionTag(newResource);
            if (this.candidateVersionTag == null) {
                this.candidateProcessDefinitionKey = this.parseProcessDefinitionKey(newResource);
                this.candidateVersionTag = String.valueOf(newVersion);
            }
            return newVersion > existingVersion;
        }
        return false;
    }

    public String determineDuplicateDeployment(CandidateDeployment candidateDeployment) {
        String deploymentId = ((ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(this.candidateProcessDefinitionKey).versionTag(String.valueOf(this.candidateVersionTag)).orderByProcessDefinitionVersion().desc()).singleResult()).getDeploymentId();
        return ((Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult()).getId();
    }

    public Set<String> determineDeploymentsToResumeByProcessDefinitionKey(String[] processDefinitionKeys) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeysIn(processDefinitionKeys).list();
        HashSet<String> deploymentIds = new HashSet<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            if (this.candidateVersionTag == null || !this.candidateVersionTag.equals(processDefinition.getVersionTag())) continue;
            deploymentIds.add(processDefinition.getDeploymentId());
        }
        return deploymentIds;
    }

    public Set<String> determineDeploymentsToResumeByDeploymentName(CandidateDeployment candidateDeployment) {
        HashSet<String> deploymentIds = new HashSet<String>();
        List previousDeployments = this.processEngine.getRepositoryService().createDeploymentQuery().deploymentName(candidateDeployment.getName()).list();
        block0: for (Deployment deployment : previousDeployments) {
            List deploymentPDs = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list();
            for (ProcessDefinition processDefinition : deploymentPDs) {
                if (this.candidateVersionTag == null || !this.candidateVersionTag.equals(processDefinition.getVersionTag())) continue;
                deploymentIds.add(deployment.getId());
                continue block0;
            }
        }
        return deploymentIds;
    }

    protected Integer parseCamundaVersionTag(Resource resource) {
        BpmnModelInstance model = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(resource.getBytes()));
        Process process = (Process)model.getDefinitions().getChildElementsByType(Process.class).iterator().next();
        return process.getCamundaVersionTag() != null ? Integer.valueOf(process.getCamundaVersionTag()) : 0;
    }

    protected String parseProcessDefinitionKey(Resource resource) {
        BpmnModelInstance model = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(resource.getBytes()));
        Process process = (Process)model.getDefinitions().getChildElementsByType(Process.class).iterator().next();
        return process.getId();
    }

    protected boolean isBpmnResource(Resource resource) {
        return StringUtil.hasAnySuffix((String)resource.getName(), (String[])BpmnDeployer.BPMN_RESOURCE_SUFFIXES);
    }
}

