/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class UpdateDuedateOnRecurringTimerTest {
    public ProcessEngineRule engineRule = new ProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    RuntimeService runtimeService;
    ManagementService managementService;
    Date t0;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.t0 = new Date(0L);
        ClockUtil.setCurrentTime((Date)this.t0);
    }

    @After
    public void resetClock() {
        ClockUtil.resetClock();
    }

    @Test
    public void testCascadeChangeToRecurringTimerAddToDuedate() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").boundaryEvent().cancelActivity(Boolean.valueOf(false))).timerWithCycle("R2/PT30M")).endEvent().moveToActivity("userTask").endEvent().done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job1 = (Job)this.managementService.createJobQuery().singleResult();
        job1 = this.modifyDueDate(job1, true, this.minutes(15));
        Date t1 = new Date(this.t0.getTime() + this.minutes(45) + 5000L);
        this.setTimeAndExecuteJobs(t1);
        Job job2 = (Job)this.managementService.createJobQuery().singleResult();
        Date t2 = new Date(t1.getTime() + this.minutes(30));
        this.setTimeAndExecuteJobs(t2);
        Assertions.assertThat((String)job1.getId()).isNotEqualTo((Object)job2.getId());
        Assertions.assertThat((long)job1.getDuedate().getTime()).isEqualTo(this.t0.getTime() + this.minutes(45));
        Assertions.assertThat((long)job2.getDuedate().getTime()).isEqualTo(job1.getDuedate().getTime() + this.minutes(30));
    }

    @Test
    public void testCascadeChangeToRecurringTimerAddToDuedateMultipleTimes() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").boundaryEvent().cancelActivity(Boolean.valueOf(false))).timerWithCycle("R3/PT30M")).endEvent().moveToActivity("userTask").endEvent().done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job1 = (Job)this.managementService.createJobQuery().singleResult();
        job1 = this.modifyDueDate(job1, true, this.minutes(15));
        Date t1 = new Date(this.t0.getTime() + this.minutes(45) + 5000L);
        this.setTimeAndExecuteJobs(t1);
        Job job2 = (Job)this.managementService.createJobQuery().singleResult();
        job2 = this.modifyDueDate(job2, true, this.negative(this.minutes(5)));
        Date t2 = new Date(t1.getTime() + this.minutes(25));
        this.setTimeAndExecuteJobs(t2);
        Job job3 = (Job)this.managementService.createJobQuery().singleResult();
        Date t3 = new Date(t2.getTime() + this.minutes(30));
        this.setTimeAndExecuteJobs(t3);
        Assertions.assertThat((Date)ClockUtil.getCurrentTime()).isAfter(job3.getDuedate());
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(0L);
        Assertions.assertThat((int)new HashSet<String>(Arrays.asList(job1.getId(), job2.getId(), job3.getId())).size()).isEqualTo(3);
        Assertions.assertThat((long)job1.getDuedate().getTime()).isEqualTo(this.t0.getTime() + this.minutes(45));
        Assertions.assertThat((long)job2.getDuedate().getTime()).isEqualTo(job1.getDuedate().getTime() + this.minutes(25));
        Assertions.assertThat((long)job3.getDuedate().getTime()).isEqualTo(job2.getDuedate().getTime() + this.minutes(30));
    }

    @Test
    public void testCascadeChangeToRecurringTimerSubstractFromDuedate() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").boundaryEvent().cancelActivity(Boolean.valueOf(false))).timerWithCycle("R2/PT30M")).endEvent().moveToActivity("userTask").endEvent().done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job1 = (Job)this.managementService.createJobQuery().singleResult();
        job1 = this.modifyDueDate(job1, true, this.negative(this.minutes(15)));
        Date t1 = new Date(this.t0.getTime() + this.minutes(15) + 5000L);
        this.setTimeAndExecuteJobs(t1);
        Job job2 = (Job)this.managementService.createJobQuery().singleResult();
        Date t2 = new Date(t1.getTime() + this.minutes(30));
        this.setTimeAndExecuteJobs(t2);
        Assertions.assertThat((String)job1.getId()).isNotEqualTo((Object)job2.getId());
        Assertions.assertThat((long)job1.getDuedate().getTime()).isEqualTo(this.t0.getTime() + this.minutes(15));
        Assertions.assertThat((long)job2.getDuedate().getTime()).isEqualTo(job1.getDuedate().getTime() + this.minutes(30));
    }

    @Test
    public void testCascadeMixedChangesToRecurringTimerDuedate() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").boundaryEvent().cancelActivity(Boolean.valueOf(false))).timerWithCycle("R3/PT30M")).endEvent().moveToActivity("userTask").endEvent().done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job1 = (Job)this.managementService.createJobQuery().singleResult();
        job1 = this.modifyDueDate(job1, true, this.negative(this.minutes(15)));
        Date t1 = new Date(this.t0.getTime() + this.minutes(15) + 5000L);
        this.setTimeAndExecuteJobs(t1);
        Job job2 = (Job)this.managementService.createJobQuery().singleResult();
        job2 = this.modifyDueDate(job2, false, this.minutes(10));
        Date t2 = new Date(t1.getTime() + this.minutes(55));
        this.setTimeAndExecuteJobs(t2);
        Job job3 = (Job)this.managementService.createJobQuery().singleResult();
        Date t3 = new Date(t2.getTime() + this.minutes(10));
        this.setTimeAndExecuteJobs(t3);
        Assertions.assertThat((int)new HashSet<String>(Arrays.asList(job1.getId(), job2.getId(), job3.getId())).size()).isEqualTo(3);
        Assertions.assertThat((long)job1.getDuedate().getTime()).isEqualTo(this.t0.getTime() + this.minutes(15));
        Assertions.assertThat((long)job2.getDuedate().getTime()).isEqualTo(job1.getDuedate().getTime() + this.minutes(40));
        Assertions.assertThat((long)job3.getDuedate().getTime()).isEqualTo(job1.getDuedate().getTime() + this.minutes(60));
    }

    @Test
    public void testChangesToRecurringTimerDuedateShouldNotCascade() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").boundaryEvent().cancelActivity(Boolean.valueOf(false))).timerWithCycle("R3/PT30M")).endEvent().moveToActivity("userTask").endEvent().done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job1 = (Job)this.managementService.createJobQuery().singleResult();
        job1 = this.modifyDueDate(job1, false, this.negative(this.minutes(15)));
        Date t1 = new Date(this.t0.getTime() + this.minutes(15) + 5000L);
        this.setTimeAndExecuteJobs(t1);
        Job job2 = (Job)this.managementService.createJobQuery().singleResult();
        Date t2 = new Date(t1.getTime() + this.minutes(15));
        this.setTimeAndExecuteJobs(t2);
        Job job3 = (Job)this.managementService.createJobQuery().singleResult();
        Date t3 = new Date(t2.getTime() + this.minutes(30));
        this.setTimeAndExecuteJobs(t3);
        Assertions.assertThat((int)new HashSet<String>(Arrays.asList(job1.getId(), job2.getId(), job3.getId())).size()).isEqualTo(3);
        Assertions.assertThat((long)job1.getDuedate().getTime()).isEqualTo(this.t0.getTime() + this.minutes(15));
        Assertions.assertThat((long)job2.getDuedate().getTime()).isEqualTo(job1.getDuedate().getTime() + this.minutes(15));
        Assertions.assertThat((long)job3.getDuedate().getTime()).isEqualTo(job2.getDuedate().getTime() + this.minutes(30));
    }

    private void setTimeAndExecuteJobs(Date time) {
        ClockUtil.setCurrentTime((Date)time);
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
    }

    private Job modifyDueDate(Job job, boolean cascade, long offset) {
        this.managementService.setJobDuedate(job.getId(), new Date(job.getDuedate().getTime() + offset), cascade);
        return (Job)this.managementService.createJobQuery().singleResult();
    }

    private long minutes(int minutes) {
        return TimeUnit.MINUTES.toMillis(minutes);
    }

    private long negative(long value) {
        return value * -1L;
    }
}

