/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.parse;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.bpmn.parse.ServiceTaskDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RetryIntervalsConfigurationTest
extends AbstractAsyncOperationsTest {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String PROCESS_ID = "process";
    private static final String FAILING_CLASS = "this.class.does.not.Exist";
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setFailedJobRetryTimeCycle("PT5M,PT20M, PT3M");
            configuration.setEnableExceptionsAfterUnhandledBpmnError(true);
            return configuration;
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private ManagementService managementService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testRetryGlobalConfiguration() throws ParseException {
        BpmnModelInstance bpmnModelInstance = this.prepareProcessFailingServiceTask();
        this.testRule.deploy(bpmnModelInstance);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        int jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)5);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)2L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)20);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)1L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)3);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)0L, (long)jobRetries);
    }

    @Test
    public void testRetryGlobalConfigurationWithExecutionListener() throws ParseException {
        this.engineRule.getProcessEngineConfiguration().setFailedJobRetryTimeCycle("PT5M");
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        int jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)1L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)5);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)0L, (long)jobRetries);
    }

    @Test
    public void testRetryMixConfiguration() throws ParseException {
        BpmnModelInstance bpmnModelInstance = this.prepareProcessFailingServiceTaskWithRetryCycle("R3/PT1M");
        this.testRule.deploy(bpmnModelInstance);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNotNull((Object)pi);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        for (int i = 0; i < 3; ++i) {
            int jobRetries = this.executeJob(processInstanceId);
            Assert.assertEquals((long)(2 - i), (long)jobRetries);
            currentTime = DateUtils.addMinutes((Date)currentTime, (int)1);
            this.assertDueDateTime(currentTime);
            ClockUtil.setCurrentTime((Date)currentTime);
        }
    }

    @Test
    public void testRetryIntervals() throws ParseException {
        BpmnModelInstance bpmnModelInstance = this.prepareProcessFailingServiceTaskWithRetryCycle("PT3M, PT10M,PT8M");
        this.testRule.deploy(bpmnModelInstance);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNotNull((Object)pi);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        int jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)3);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)2L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)10);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)1L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)8);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)0L, (long)jobRetries);
    }

    @Test
    public void testSingleRetryInterval() throws ParseException {
        BpmnModelInstance bpmnModelInstance = this.prepareProcessFailingServiceTaskWithRetryCycle("PT8M ");
        this.testRule.deploy(bpmnModelInstance);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNotNull((Object)pi);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        int jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)1L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)8);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)0L, (long)jobRetries);
    }

    @Test
    public void testRetryWithVarList() {
        BpmnModelInstance bpmnModelInstance = this.prepareProcessFailingServiceTaskWithRetryCycle("${var}");
        this.testRule.deploy(bpmnModelInstance);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID, (Map)Variables.createVariables().putValue("var", (Object)"PT1M,PT2M,PT3M,PT4M,PT5M,PT6M,PT7M,PT8M"));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)8L, (long)job.getRetries());
    }

    @Test
    public void testIntervalsAfterUpdateRetries() throws ParseException {
        BpmnModelInstance bpmnModelInstance = this.prepareProcessFailingServiceTaskWithRetryCycle("PT3M, PT10M,PT8M");
        this.testRule.deploy(bpmnModelInstance);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNotNull((Object)pi);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        int jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)3);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.managementService.setJobRetries(Arrays.asList(job.getId()), 5);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)4L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)3);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)3);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)2L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)10);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)1L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)8);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)0L, (long)jobRetries);
    }

    @Test
    public void testMixConfigurationWithinOneProcess() throws ParseException {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("Task1").camundaClass(ServiceTaskDelegate.class.getName())).camundaAsyncBefore()).serviceTask("Task2").camundaClass(FAILING_CLASS)).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("PT3M, PT10M,PT8M")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNotNull((Object)pi);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        int jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)5);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        ServiceTaskDelegate.firstAttempt = false;
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)3);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
    }

    @Test
    public void testlocalConfigurationWithNestedChangingExpression() throws ParseException {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("${var}")).endEvent().done();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date startDate = simpleDateFormat.parse("2017-01-01T09:55:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.testRule.deploy(bpmnModelInstance);
        VariableMap params = Variables.createVariables();
        params.putValue("var", (Object)"${nestedVar1},PT15M,${nestedVar3}");
        params.putValue("nestedVar", (Object)"PT13M");
        params.putValue("nestedVar1", (Object)"PT5M");
        params.putValue("nestedVar3", (Object)"PT25M");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID, (Map)params);
        ClockUtil.setCurrentTime((Date)SIMPLE_DATE_FORMAT.parse("2017-01-01T09:55:00"));
        Assert.assertNotNull((Object)pi);
        Date currentTime = SIMPLE_DATE_FORMAT.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)currentTime);
        String processInstanceId = pi.getProcessInstanceId();
        int jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)3L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)5);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)2L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)15);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        this.runtimeService.setVariable(pi.getProcessInstanceId(), "var", (Object)"${nestedVar}");
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)1L, (long)jobRetries);
        currentTime = DateUtils.addMinutes((Date)currentTime, (int)13);
        this.assertDueDateTime(currentTime);
        ClockUtil.setCurrentTime((Date)currentTime);
        jobRetries = this.executeJob(processInstanceId);
        Assert.assertEquals((long)0L, (long)jobRetries);
    }

    private int executeJob(String processInstanceId) {
        Job job = this.fetchJob(processInstanceId);
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = this.fetchJob(processInstanceId);
        return job.getRetries();
    }

    private void assertDueDateTime(Date expectedDate) throws ParseException {
        Date dueDateTime = ((Job)this.managementService.createJobQuery().singleResult()).getDuedate();
        Assert.assertEquals((Object)expectedDate, (Object)dueDateTime);
    }

    private Job fetchJob(String processInstanceId) {
        return (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
    }

    private BpmnModelInstance prepareProcessFailingServiceTask() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).endEvent().done();
        return modelInstance;
    }

    private BpmnModelInstance prepareProcessFailingServiceTaskWithRetryCycle(String retryTimeCycle) {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle(retryTimeCycle)).endEvent().done();
        return modelInstance;
    }
}

