/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class HistoricBatchManagerBatchesForCleanupTest {
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    public MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    public BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected HistoryService historyService;
    @Parameterized.Parameter(value=0)
    public int historicBatchHistoryTTL;
    @Parameterized.Parameter(value=1)
    public int daysInThePast;
    @Parameterized.Parameter(value=2)
    public int batch1EndTime;
    @Parameterized.Parameter(value=3)
    public int batch2EndTime;
    @Parameterized.Parameter(value=4)
    public int batchSize;
    @Parameterized.Parameter(value=5)
    public int resultCount;

    @Before
    public void init() {
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void clearDatabase() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({5, -11, -6, -7, 50, 2}, {5, -11, -3, -7, 50, 1}, {5, -11, -3, -4, 50, 0}, {5, -11, -6, -7, 1, 1});
    }

    @Test
    public void testFindHistoricBatchIdsForCleanup() {
        String batchType = this.prepareHistoricBatches(2);
        HashedMap batchOperationsMap = new HashedMap();
        batchOperationsMap.put(batchType, this.historicBatchHistoryTTL);
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Object>((Map)batchOperationsMap){
            final /* synthetic */ Map val$batchOperationsMap;
            {
                this.val$batchOperationsMap = map;
            }

            public Object execute(CommandContext commandContext) {
                List historicBatchIdsForCleanup = commandContext.getHistoricBatchManager().findHistoricBatchIdsForCleanup(Integer.valueOf(HistoricBatchManagerBatchesForCleanupTest.this.batchSize), this.val$batchOperationsMap, 0, 59);
                Assert.assertEquals((long)HistoricBatchManagerBatchesForCleanupTest.this.resultCount, (long)historicBatchIdsForCleanup.size());
                if (HistoricBatchManagerBatchesForCleanupTest.this.resultCount > 0) {
                    List historicBatches = HistoricBatchManagerBatchesForCleanupTest.this.historyService.createHistoricBatchQuery().list();
                    for (HistoricBatch historicBatch : historicBatches) {
                        historicBatch.getEndTime().before(DateUtils.addDays((Date)ClockUtil.getCurrentTime(), (int)HistoricBatchManagerBatchesForCleanupTest.this.historicBatchHistoryTTL));
                    }
                }
                return null;
            }
        });
    }

    private String prepareHistoricBatches(int batchesCount) {
        Date startDate = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)this.daysInThePast));
        ArrayList<Batch> list = new ArrayList<Batch>();
        for (int i = 0; i < batchesCount; ++i) {
            list.add(this.helper.migrateProcessInstancesAsync(1));
        }
        Batch batch1 = (Batch)list.get(0);
        String batchType = batch1.getType();
        this.helper.executeSeedJob(batch1);
        this.helper.executeJobs(batch1);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)this.batch1EndTime));
        this.helper.executeMonitorJob(batch1);
        Batch batch2 = (Batch)list.get(1);
        this.helper.executeSeedJob(batch2);
        this.helper.executeJobs(batch2);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)this.batch2EndTime));
        this.helper.executeMonitorJob(batch2);
        ClockUtil.setCurrentTime((Date)new Date());
        return batchType;
    }
}

