/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricFormField;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.history.NativeHistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.util.CustomSerializable;
import org.camunda.bpm.engine.test.api.runtime.util.FailingSerializable;
import org.camunda.bpm.engine.test.cmmn.decisiontask.TestPojo;
import org.camunda.bpm.engine.test.history.RemoveAndUpdateValueDelegate;
import org.camunda.bpm.engine.test.history.SubProcessActivityStartListener;
import org.camunda.bpm.engine.test.history.UpdateAndReplaceValueDelegate;
import org.camunda.bpm.engine.test.history.UpdateHistoricDetailValueDelegate;
import org.camunda.bpm.engine.test.history.UpdateHistoricValueDelegate;
import org.camunda.bpm.engine.test.history.UpdateValueDelegate;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="audit")
public class HistoricVariableInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/orderProcess.bpmn20.xml", "org/camunda/bpm/engine/test/history/checkCreditProcess.bpmn20.xml"})
    public void testOrderProcessWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("orderProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task verifyCreditTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"Verify credit history", (String)verifyCreditTask.getName());
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(pi.getId()).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)subProcessInstance);
        HistoricVariableInstanceTest.assertEquals((String)pi.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
        this.taskService.complete(verifyCreditTask.getId(), CollectionUtil.singletonMap((String)"creditApproved", (Object)true));
        Task prepareAndShipTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"Prepare and Ship", (String)prepareAndShipTask.getName());
    }

    @Deployment
    public void testSimple() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testSimpleNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testParallel() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"myVar", (String)historicVariable.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test789", (String)historicVariable.getTextValue());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        HistoricVariableInstanceTest.assertEquals((String)"myVar1", (String)historicVariable1.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable1.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testParallelNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)7L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testTwoSubProcessInParallelWithinSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallelWithinSubProcess");
        this.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"myVar", (String)historicVariable.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test101112", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable.getVariableTypeName());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable.getTypeName());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        HistoricVariableInstanceTest.assertEquals((String)"myVar1", (String)historicVariable1.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test789", (String)historicVariable1.getTextValue());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable1.getVariableTypeName());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable1.getTypeName());
        HistoricVariableInstanceTest.assertEquals((long)18L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/history/simpleSubProcess.bpmn20.xml"})
    public void testHistoricVariableInstanceQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((int)5, (int)this.historyService.createHistoricVariableInstanceQuery().list().size());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricVariableInstanceTest.assertEquals((int)5, (int)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).count());
        HistoricVariableInstanceTest.assertEquals((int)5, (int)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("my\\_Var%").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("my\\_Var%").list().size());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)5, (int)variables.size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").list().size());
        HistoricVariableInstanceTest.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)6L, (long)this.historyService.createHistoricDetailQuery().count());
        }
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId("non-existing").count());
        List variable = this.historyService.createHistoricVariableInstanceQuery().listPage(0, 1);
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId(((HistoricVariableInstance)variable.get(0)).getId()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSubProcessSettingVariableOnStart.bpmn20.xml", "org/camunda/bpm/engine/test/history/subProcessSetVariableOnStart.bpmn20.xml"})
    public void testCallSubProcessSettingVariableOnStart() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSubProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("aVariable", (Object)"aValue").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessVariableOnDeletion() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "Hallo Christian");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "deleted");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableValueEquals("testVar", (Object)"Hallo Christian").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdatesAreLinkedToActivity.bpmn20.xml"})
    public void testVariableUpdatesLinkedToActivity() throws Exception {
        if (this.isFullHistoryEnabled()) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("ProcessWithSubProcess");
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("test", "1");
            this.taskService.complete(task.getId(), variables);
            task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            variables.clear();
            variables.put("test", "2");
            this.taskService.complete(task.getId(), variables);
            this.assertProcessEnded(pi.getId());
            List updates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
            HistoricVariableInstanceTest.assertEquals((int)2, (int)updates.size());
            HashMap<String, HistoricVariableUpdate> updatesMap = new HashMap<String, HistoricVariableUpdate>();
            HistoricVariableUpdate update = (HistoricVariableUpdate)updates.get(0);
            updatesMap.put((String)update.getValue(), update);
            update = (HistoricVariableUpdate)updates.get(1);
            updatesMap.put((String)update.getValue(), update);
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)updatesMap.get("1");
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)updatesMap.get("2");
            HistoricVariableInstanceTest.assertNotNull((Object)update1.getActivityInstanceId());
            HistoricVariableInstanceTest.assertNotNull((Object)update1.getExecutionId());
            HistoricActivityInstance historicActivityInstance1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update1.getActivityInstanceId()).singleResult();
            HistoricVariableInstanceTest.assertEquals((String)historicActivityInstance1.getExecutionId(), (String)update1.getExecutionId());
            HistoricVariableInstanceTest.assertEquals((String)"usertask1", (String)historicActivityInstance1.getActivityId());
            HistoricVariableInstanceTest.assertNotNull((Object)update2.getActivityInstanceId());
            HistoricActivityInstance historicActivityInstance2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update2.getActivityInstanceId()).singleResult();
            HistoricVariableInstanceTest.assertEquals((String)"usertask2", (String)historicActivityInstance2.getActivityId());
            HistoricVariableInstanceTest.assertFalse((boolean)historicActivityInstance2.getExecutionId().equals(update2.getExecutionId()));
        }
    }

    @Deployment
    public void testHistoricProcessInstanceDeleteCascadesCorrectly() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "value1");
        variables.put("var2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        HistoricVariableInstanceTest.assertNotNull((Object)processInstance);
        variables = new HashMap();
        variables.put("var3", "value3");
        variables.put("var4", "value4");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        HistoricVariableInstanceTest.assertNotNull((Object)processInstance2);
        long count = this.historyService.createHistoricVariableInstanceQuery().count();
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)count);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "reason 1");
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        count = this.historyService.createHistoricVariableInstanceQuery().count();
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByTaskIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.setVariableLocal(userTask.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.complete(userTask.getId());
        this.assertProcessEnded(processInstance.getId());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)tasks.size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByProcessIdIn() {
        HashMap vars = new HashMap();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc", vars);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("myProc", vars);
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), processInstance2.getProcessInstanceId()}).count());
        HistoricVariableInstanceTest.assertEquals((int)4, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), processInstance2.getProcessInstanceId()}).list().size());
        String notExistingSearch = processInstance.getProcessInstanceId() + "-notExisting";
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{notExistingSearch, processInstance2.getProcessInstanceId()}).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByInvalidProcessIdIn() {
        HashMap vars = new HashMap();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc", vars);
        try {
            this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), null});
            HistoricVariableInstanceTest.fail((String)"Search by process instance ID was finished");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{null, processInstance.getProcessInstanceId()});
            HistoricVariableInstanceTest.fail((String)"Search by process instance ID was finished");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByExecutionIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId()});
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)query.count());
        List variableInstances = query.list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variableInstances.size());
        for (HistoricVariableInstance variableInstance : variableInstances) {
            HistoricVariableInstanceTest.assertEquals((String)processInstance1.getId(), (String)variableInstance.getExecutionId());
        }
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        HistoricVariableInstanceTest.assertEquals((int)3, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)query.count());
    }

    public void testQueryByInvalidExecutionIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidTaskIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByActivityInstanceIdIn() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{processInstance1.getId()});
        HistoricVariableInstanceTest.assertEquals((int)2, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)query.count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        query.activityInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        HistoricVariableInstanceTest.assertEquals((int)3, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)query.count());
    }

    public void testQueryByInvalidActivityInstanceIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.taskIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            query.taskIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.taskIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeIn() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().variableTypeIn(new String[]{"string"});
        HistoricVariableInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstanceTest.assertEquals((String)((HistoricVariableInstance)query.list().get(0)).getName(), (String)"stringVar");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeInWithCapitalLetter() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.variableTypeIn(new String[]{"Boolean"});
        HistoricVariableInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstanceTest.assertEquals((String)((HistoricVariableInstance)query.list().get(0)).getName(), (String)"boolVar");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeInWithSeveralTypes() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        variables1.put("intVar", 5);
        variables1.put("nullVar", null);
        variables1.put("pojoVar", new TestPojo("str", 0.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.variableTypeIn(new String[]{"BooLEAN", "string", "Serializable"});
        HistoricVariableInstanceTest.assertEquals((int)3, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)query.count());
    }

    public void testQueryByInvalidVariableTypeIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.variableTypeIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            query.variableTypeIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.variableTypeIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testBinaryFetchingEnabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testBinaryFetchingDisabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).disableBinaryFetching().singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDisableBinaryFetchingForFileValues() {
        String fileName = "text.txt";
        String encoding = "crazy-encoding";
        String mimeType = "martini/dry";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file("ABC".getBytes()).encoding(encoding).mimeType(mimeType).create();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        HistoricVariableInstance fileVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)fileVariableInstance.getValue());
        fileVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().disableBinaryFetching().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)fileVariableInstance);
        HistoricVariableInstanceTest.assertEquals((String)"fileVar", (String)fileVariableInstance.getName());
        HistoricVariableInstanceTest.assertNull((Object)fileVariableInstance.getValue());
        FileValue typedValue = (FileValue)fileVariableInstance.getTypedValue();
        HistoricVariableInstanceTest.assertNull((Object)typedValue.getValue());
        HistoricVariableInstanceTest.assertEquals((Object)ValueType.FILE, (Object)typedValue.getType());
        HistoricVariableInstanceTest.assertEquals((String)fileName, (String)typedValue.getFilename());
        HistoricVariableInstanceTest.assertEquals((String)encoding, (String)typedValue.getEncoding());
        HistoricVariableInstanceTest.assertEquals((String)mimeType, (String)typedValue.getMimeType());
    }

    public void testDisableCustomObjectDeserialization() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        this.taskService.setVariables(newTask.getId(), variables);
        List variableInstances = this.historyService.createHistoricVariableInstanceQuery().disableCustomObjectDeserialization().list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variableInstances.size());
        for (HistoricVariableInstance variableInstance : variableInstances) {
            HistoricVariableInstanceTest.assertNull((Object)variableInstance.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableInstance.getTypedValue();
            HistoricVariableInstanceTest.assertNotNull((Object)typedValue);
            HistoricVariableInstanceTest.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            HistoricVariableInstanceTest.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testDisableCustomObjectDeserializationNativeQuery() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        this.taskService.setVariables(newTask.getId(), variables);
        List variableInstances = ((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT * from " + this.managementService.getTableName(HistoricVariableInstance.class))).disableCustomObjectDeserialization().list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variableInstances.size());
        for (HistoricVariableInstance variableInstance : variableInstances) {
            HistoricVariableInstanceTest.assertNull((Object)variableInstance.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableInstance.getTypedValue();
            HistoricVariableInstanceTest.assertNotNull((Object)typedValue);
            HistoricVariableInstanceTest.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            HistoricVariableInstanceTest.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testErrorMessage() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "failingSerializable";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)new FailingSerializable());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variableInstance.getValue());
        HistoricVariableInstanceTest.assertNotNull((Object)variableInstance.getErrorMessage());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Deployment
    public void testHistoricVariableInstanceRevision() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstanceEntity variableEntity = (HistoricVariableInstanceEntity)variable;
        HistoricVariableInstanceTest.assertEquals((int)0, (int)variableEntity.getRevision());
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableRevision().asc()).list();
            for (HistoricDetail detail : details) {
                HistoricVariableUpdate variableDetail = (HistoricVariableUpdate)detail;
                HistoricVariableInstanceTest.assertEquals((int)0, (int)variableDetail.getRevision());
            }
        }
    }

    @Deployment
    public void testHistoricVariableInstanceRevisionAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstanceEntity variableEntity = (HistoricVariableInstanceEntity)variable;
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variableEntity.getRevision());
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableRevision().asc()).list();
            int i = 0;
            for (HistoricDetail detail : details) {
                HistoricVariableUpdate variableDetail = (HistoricVariableUpdate)detail;
                HistoricVariableInstanceTest.assertEquals((int)i, (int)variableDetail.getRevision());
                ++i;
            }
        }
    }

    @Deployment
    public void testImplicitVariableUpdate() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        HistoricVariableInstanceTest.assertNotNull((Object)list);
        HistoricVariableInstanceTest.assertEquals((int)1, (int)list.size());
        HistoricVariableInstanceTest.assertEquals((String)"new element", (String)((String)list.get(0)));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        List historicList = (List)historicVariableInstance.getValue();
        HistoricVariableInstanceTest.assertNotNull((Object)historicList);
        HistoricVariableInstanceTest.assertEquals((int)1, (int)historicList.size());
        HistoricVariableInstanceTest.assertEquals((String)"new element", (String)((String)historicList.get(0)));
        if (this.isFullHistoryEnabled()) {
            List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)2, (int)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)historicDetails.get(1);
            List value1 = (List)update1.getValue();
            HistoricVariableInstanceTest.assertNotNull((Object)value1);
            HistoricVariableInstanceTest.assertTrue((boolean)value1.isEmpty());
            List value2 = (List)update2.getValue();
            HistoricVariableInstanceTest.assertNotNull((Object)value2);
            HistoricVariableInstanceTest.assertEquals((int)1, (int)value2.size());
            HistoricVariableInstanceTest.assertEquals((String)"new element", (String)((String)value2.get(0)));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testImplicitVariableUpdate.bpmn20.xml"})
    public void FAILING_testImplicitVariableUpdateActivityInstanceId() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        HistoricActivityInstance historicServiceTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult();
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        HistoricVariableInstanceTest.assertNotNull((Object)list);
        HistoricVariableInstanceTest.assertEquals((int)1, (int)list.size());
        HistoricVariableInstanceTest.assertEquals((String)"new element", (String)((String)list.get(0)));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        HistoricVariableInstanceTest.assertEquals((String)historicServiceTask.getId(), (String)historicVariableInstance.getActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testImplicitVariableUpdate.bpmn20.xml"})
    public void FAILING_testImplicitVariableUpdateAndReplacementInOneTransaction() {
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateAndReplaceValueDelegate()));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        List historicList = (List)historicVariableInstance.getValue();
        HistoricVariableInstanceTest.assertNotNull((Object)historicList);
        HistoricVariableInstanceTest.assertEquals((int)0, (int)historicList.size());
        if (this.isFullHistoryEnabled()) {
            List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)historicDetails.get(1);
            HistoricVariableUpdate update3 = (HistoricVariableUpdate)historicDetails.get(2);
            List value1 = (List)update1.getValue();
            HistoricVariableInstanceTest.assertNotNull((Object)value1);
            HistoricVariableInstanceTest.assertTrue((boolean)value1.isEmpty());
            List value2 = (List)update2.getValue();
            HistoricVariableInstanceTest.assertNotNull((Object)value2);
            HistoricVariableInstanceTest.assertEquals((int)1, (int)value2.size());
            HistoricVariableInstanceTest.assertEquals((String)"new element", (String)((String)value2.get(0)));
            List value3 = (List)update3.getValue();
            HistoricVariableInstanceTest.assertNotNull((Object)value3);
            HistoricVariableInstanceTest.assertTrue((boolean)value3.isEmpty());
        }
    }

    @RequiredHistoryLevel(value="full")
    public void testImplicitVariableUpdateAndScopeDestroyedInOneTransaction() {
        this.deployment(new BpmnModelInstance[]{((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("task1").camundaExpression("${var.setValue(\"newValue\")}")).endEvent("end").done()});
        this.processEngine.getRuntimeService().startProcessInstanceByKey("process1", (Map)Variables.createVariables().putValue("var", (Object)new CustomVar("initialValue")));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.processEngine.getHistoryService().createHistoricVariableInstanceQuery().list().get(0);
        CustomVar var = (CustomVar)historicVariableInstance.getTypedValue().getValue();
        HistoricVariableInstanceTest.assertEquals((String)"newValue", (String)var.getValue());
        List historicDetails = ((HistoricDetailQuery)this.processEngine.getHistoryService().createHistoricDetailQuery().orderPartiallyByOccurrence().desc()).list();
        HistoricDetail historicDetail = (HistoricDetail)historicDetails.get(0);
        CustomVar typedValue = (CustomVar)((HistoricVariableUpdate)historicDetail).getTypedValue().getValue();
        HistoricVariableInstanceTest.assertEquals((String)"newValue", (String)typedValue.getValue());
    }

    @Deployment
    public void testNoImplicitUpdateOnHistoricValues() {
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateHistoricValueDelegate()));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        List historicList = (List)historicVariableInstance.getValue();
        HistoricVariableInstanceTest.assertNotNull((Object)historicList);
        HistoricVariableInstanceTest.assertEquals((int)0, (int)historicList.size());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
            List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).list();
            HistoricVariableInstanceTest.assertEquals((int)1, (int)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            List value1 = (List)update1.getValue();
            HistoricVariableInstanceTest.assertNotNull((Object)value1);
            HistoricVariableInstanceTest.assertTrue((boolean)value1.isEmpty());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testImplicitVariableUpdate.bpmn20.xml"})
    public void testImplicitVariableRemoveAndUpdateInOneTransaction() {
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new RemoveAndUpdateValueDelegate()));
        if (this.isFullHistoryEnabled()) {
            List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderPartiallyByOccurrence().asc()).list();
            Iterator detailsIt = historicDetails.iterator();
            while (detailsIt.hasNext()) {
                if ("listVar".equals(((HistoricVariableUpdate)detailsIt.next()).getVariableName())) continue;
                detailsIt.remove();
            }
            HistoricVariableInstanceTest.assertEquals((int)2, (int)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            List value1 = (List)update1.getValue();
            HistoricVariableInstanceTest.assertNotNull((Object)value1);
            HistoricVariableInstanceTest.assertTrue((boolean)value1.isEmpty());
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)historicDetails.get(1);
            HistoricVariableInstanceTest.assertNull((Object)update2.getValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testNoImplicitUpdateOnHistoricValues.bpmn20.xml"})
    public void testNoImplicitUpdateOnHistoricDetailValues() {
        if (!this.isFullHistoryEnabled()) {
            return;
        }
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateHistoricDetailValueDelegate()));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)historicDetails.size());
        HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
        List value1 = (List)update1.getValue();
        HistoricVariableInstanceTest.assertNotNull((Object)value1);
        HistoricVariableInstanceTest.assertTrue((boolean)value1.isEmpty());
    }

    protected boolean isFullHistoryEnabled() {
        return this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testHistoricVariableInstanceRevision.bpmn20.xml"})
    public void testVariableUpdateOrder() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variable.getId()).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testHistoricVariableInstanceRevisionAsync.bpmn20.xml"})
    public void testVariableUpdateOrderAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variable.getId()).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskVariableUpdateOrder() {
        HistoricVariableUpdate fourthUpdate;
        HistoricVariableUpdate thirdUpdate;
        HistoricVariableUpdate secondUpdate;
        HistoricVariableUpdate firstUpdate;
        List details;
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)1);
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)2);
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)3);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)"abc");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)4, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.taskService.removeVariable(taskId, "myVariable");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)5, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate fifthUpdate = (HistoricVariableUpdate)details.get(4);
            HistoricVariableInstanceTest.assertNull((Object)fifthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fifthUpdate).getSequenceCounter() > ((HistoryEvent)fourthUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCaseVariableUpdateOrder() {
        HistoricVariableUpdate fourthUpdate;
        HistoricVariableUpdate thirdUpdate;
        HistoricVariableUpdate secondUpdate;
        HistoricVariableUpdate firstUpdate;
        List details;
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)1);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)2);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)3);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)"abc");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)4, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.caseService.removeVariable(caseInstanceId, "myVariable");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)5, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate fifthUpdate = (HistoricVariableUpdate)details.get(4);
            HistoricVariableInstanceTest.assertNull((Object)fifthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fifthUpdate).getSequenceCounter() > ((HistoryEvent)fourthUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSameVariableUpdateOrder() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(taskId, "myVariable", (Object)1);
        this.taskService.setVariable(taskId, "myVariable", (Object)1);
        this.taskService.setVariable(taskId, "myVariable", (Object)2);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionProperty() {
        String key = "oneTaskProcess";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key);
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"aValue");
        this.taskService.setVariableLocal(taskId, "aLocalVariable", (Object)"anotherValue");
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("aVariable").singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)instance.getProcessDefinitionKey());
        HistoricVariableInstanceTest.assertEquals((String)key, (String)instance.getProcessDefinitionKey());
        HistoricVariableInstanceTest.assertNotNull((Object)instance.getProcessDefinitionId());
        HistoricVariableInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)instance.getProcessDefinitionId());
        HistoricVariableInstanceTest.assertNull((Object)instance.getCaseDefinitionKey());
        HistoricVariableInstanceTest.assertNull((Object)instance.getCaseDefinitionId());
        instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("aLocalVariable").singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)instance.getProcessDefinitionKey());
        HistoricVariableInstanceTest.assertEquals((String)key, (String)instance.getProcessDefinitionKey());
        HistoricVariableInstanceTest.assertNotNull((Object)instance.getProcessDefinitionId());
        HistoricVariableInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)instance.getProcessDefinitionId());
        HistoricVariableInstanceTest.assertNull((Object)instance.getCaseDefinitionKey());
        HistoricVariableInstanceTest.assertNull((Object)instance.getCaseDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCaseDefinitionProperty() {
        String key = "oneTaskCase";
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(key);
        String caseInstanceId = caseInstance.getId();
        ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.caseService.setVariable(caseInstanceId, "aVariable", (Object)"aValue");
        this.taskService.setVariableLocal(taskId, "aLocalVariable", (Object)"anotherValue");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).variableName("aVariable").singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).variableName("aVariable").singleResult();
        this.assertCaseVariable(key, caseInstance, instance);
        instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).variableName("aLocalVariable").singleResult();
        this.assertCaseVariable(key, caseInstance, instance);
        instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).variableId(variable.getId()).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)instance);
        this.assertCaseVariable(key, caseInstance, instance);
    }

    protected void assertCaseVariable(String key, CaseInstance caseInstance, HistoricVariableInstance instance) {
        HistoricVariableInstanceTest.assertNotNull((Object)instance.getCaseDefinitionKey());
        HistoricVariableInstanceTest.assertEquals((String)key, (String)instance.getCaseDefinitionKey());
        HistoricVariableInstanceTest.assertNotNull((Object)instance.getCaseDefinitionId());
        HistoricVariableInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        HistoricVariableInstanceTest.assertNull((Object)instance.getProcessDefinitionKey());
        HistoricVariableInstanceTest.assertNull((Object)instance.getProcessDefinitionId());
    }

    public void testStandaloneTaskDefinitionProperties() {
        String taskId = "myTask";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setVariable(taskId, "aVariable", (Object)"anotherValue");
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{taskId}).variableName("aVariable").singleResult();
        HistoricVariableInstanceTest.assertNull((Object)instance.getProcessDefinitionKey());
        HistoricVariableInstanceTest.assertNull((Object)instance.getProcessDefinitionId());
        HistoricVariableInstanceTest.assertNull((Object)instance.getCaseDefinitionKey());
        HistoricVariableInstanceTest.assertNull((Object)instance.getCaseDefinitionId());
        this.taskService.deleteTask(taskId, true);
    }

    public void testTaskIdProperty() {
        String taskId = "myTask";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setVariable(taskId, "aVariable", (Object)"anotherValue");
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{taskId}).variableName("aVariable").singleResult();
        HistoricVariableInstanceTest.assertEquals((String)taskId, (String)instance.getTaskId());
        this.taskService.deleteTask(taskId, true);
    }

    @Deployment
    public void testJoinParallelGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)historicVariable);
        HistoricVariableInstanceTest.assertEquals((String)"testVar", (String)historicVariable.getName());
    }

    @Deployment
    public void testNestedJoinParallelGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)historicVariable);
        HistoricVariableInstanceTest.assertEquals((String)"testVar", (String)historicVariable.getName());
    }

    @Deployment
    public void testJoinInclusiveGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)historicVariable);
        HistoricVariableInstanceTest.assertEquals((String)"testVar", (String)historicVariable.getName());
    }

    @Deployment
    public void testNestedJoinInclusiveGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)historicVariable);
        HistoricVariableInstanceTest.assertEquals((String)"testVar", (String)historicVariable.getName());
    }

    @Deployment
    public void testForkParallelGatewayTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)historicVariable);
        HistoricVariableInstanceTest.assertEquals((String)"foo", (String)historicVariable.getName());
    }

    @Deployment
    public void testNestedForkParallelGatewayTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)historicVariable);
        HistoricVariableInstanceTest.assertEquals((String)"foo", (String)historicVariable.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseActivityId() {
        this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.putValue((String)"foo", (Object)"bar"));
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.setVariableLocal(caseExecution.getId(), "bar", (Object)"foo");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1"});
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstanceTest.assertEquals((String)"bar", (String)((HistoricVariableInstance)query.singleResult()).getName());
        HistoricVariableInstanceTest.assertEquals((Object)"foo", (Object)((HistoricVariableInstance)query.singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testQueryByCaseActivityIds() {
        this.caseService.createCaseInstanceByKey("twoTaskCase");
        CaseExecution caseExecution1 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.setVariableLocal(caseExecution1.getId(), "foo", (Object)"bar");
        CaseExecution caseExecution2 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2").singleResult();
        this.caseService.setVariableLocal(caseExecution2.getId(), "bar", (Object)"foo");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1", "PI_HumanTask_2"});
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)query.count());
    }

    public void testQueryByInvalidCaseActivityIds() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.caseActivityIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            query.caseActivityIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            query.caseActivityIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            String[] values = new String[]{"a", null, "b"};
            query.caseActivityIdIn(values);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testSetVariableInSubProcessStartEventWithEndListener() throws Exception {
        BpmnModelInstance topProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"topProcess").startEvent().callActivity().calledElement("subProcess")).camundaIn("executionListenerCounter", "executionListenerCounter")).endEvent().done();
        BpmnModelInstance subProcess = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"subProcess").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("end", "org.camunda.bpm.engine.test.history.SubProcessActivityStartListener")).endEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", topProcess).addModelInstance("subProcess.bpmn", subProcess).deploy();
        this.runtimeService.startProcessInstanceByKey("topProcess", (Map)Variables.createVariables().putValue("executionListenerCounter", (Object)1));
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().active().singleResult()).getId());
        Assert.assertThat((Object)this.historyService.createHistoricVariableInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testSetVariableInEndListenerOfAsyncStartEvent() throws Exception {
        BpmnModelInstance subProcess = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("end", SubProcessActivityStartListener.class.getName())).endEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", subProcess).deploy();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("executionListenerCounter", (Object)1));
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().active().singleResult()).getId());
        Assert.assertThat((Object)this.historyService.createHistoricVariableInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testSetVariableInStartListenerOfAsyncStartEvent() throws Exception {
        BpmnModelInstance subProcess = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("start", SubProcessActivityStartListener.class.getName())).endEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", subProcess).deploy();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("executionListenerCounter", (Object)1));
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().active().singleResult()).getId());
        Assert.assertThat((Object)this.historyService.createHistoricVariableInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventHistory() {
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
            HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
            Assert.assertNotNull((Object)historicInstance);
            Assert.assertNotNull((Object)historicInstance.getStartTime());
            HistoricActivityInstance historicStartEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().singleResult();
            Assert.assertNull((Object)historicStartEvent);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("asyncStartEvent", variables).getId();
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variableFoo);
        HistoricVariableInstanceTest.assertEquals((String)"foo", (String)variableFoo.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            HistoricVariableInstanceTest.assertNotNull((Object)variable);
            HistoricVariableInstanceTest.assertEquals((String)"foo", (String)variable.getName());
            HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)variable.getValue());
            HistoricVariableInstanceTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                String startEventId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                HistoricVariableInstanceTest.assertEquals((String)startEventId, (String)historicDetail.getActivityInstanceId());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testMultipleAsyncStartEvents.bpmn20.xml"})
    public void testMultipleAsyncStartEventsVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variableFoo);
        HistoricVariableInstanceTest.assertEquals((String)"foo", (String)variableFoo.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            HistoricVariableInstanceTest.assertNotNull((Object)variable);
            HistoricVariableInstanceTest.assertEquals((String)"foo", (String)variable.getName());
            HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)variable.getValue());
            HistoricVariableInstanceTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("messageStartEvent").singleResult()).getId();
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                HistoricVariableInstanceTest.assertEquals((String)theStartActivityInstanceId, (String)historicDetail.getActivityInstanceId());
            }
        }
    }

    public void testAsyncStartEventWithAddedVariable() {
        this.deployment(new BpmnModelInstance[]{((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done()});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.putValue((String)"var1", (Object)"foo"));
        this.runtimeService.setVariable(processInstance.getId(), "var2", (Object)"bar");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            HistoricVariableInstanceTest.assertEquals((long)query.count(), (long)2L);
            HistoricVariableInstance firstVariable = (HistoricVariableInstance)query.variableName("var1").singleResult();
            HistoricVariableInstanceTest.assertNotNull((Object)firstVariable);
            HistoricVariableInstanceTest.assertEquals((Object)firstVariable.getValue(), (Object)"foo");
            HistoricVariableInstanceTest.assertNotNull((Object)firstVariable.getActivityInstanceId());
            HistoricVariableInstance secondVariable = (HistoricVariableInstance)query.variableName("var2").singleResult();
            HistoricVariableInstanceTest.assertNotNull((Object)secondVariable);
            HistoricVariableInstanceTest.assertEquals((Object)secondVariable.getValue(), (Object)"bar");
            HistoricVariableInstanceTest.assertNotNull((Object)secondVariable.getActivityInstanceId());
        }
    }

    public void testAsyncStartEventWithChangedVariable() {
        this.deployment(new BpmnModelInstance[]{((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done()});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.putValue((String)"var", (Object)"foo"));
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)"bar");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            HistoricVariableInstanceTest.assertEquals((long)query.count(), (long)1L);
            HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
            HistoricVariableInstanceTest.assertEquals((Object)variable.getValue(), (Object)"bar");
            HistoricVariableInstanceTest.assertNotNull((Object)variable.getActivityInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testSubmitForm() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("asyncStartEvent").singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        this.formService.submitStartForm(processDefinitionId, properties);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variableFoo);
        HistoricVariableInstanceTest.assertEquals((String)"foo", (String)variableFoo.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            HistoricVariableInstanceTest.assertNotNull((Object)variable);
            HistoricVariableInstanceTest.assertEquals((String)"foo", (String)variable.getName());
            HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)variable.getValue());
            HistoricVariableInstanceTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
                HistoricFormField historicFormUpdate = (HistoricFormField)this.historyService.createHistoricDetailQuery().formFields().singleResult();
                HistoricVariableInstanceTest.assertNotNull((Object)historicFormUpdate);
                HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)historicFormUpdate.getFieldValue());
                HistoricVariableUpdate historicVariableUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().singleResult();
                HistoricVariableInstanceTest.assertNotNull((Object)historicVariableUpdate);
                HistoricVariableInstanceTest.assertEquals((String)theStartActivityInstanceId, (String)historicVariableUpdate.getActivityInstanceId());
                HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)historicVariableUpdate.getValue());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void FAILING_testSubmitFormHistoricUpdates() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("asyncStartEvent").singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        this.formService.submitStartForm(processDefinitionId, properties);
        this.executeAvailableJobs();
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
            HistoricDetail historicFormUpdate = (HistoricDetail)this.historyService.createHistoricDetailQuery().formFields().singleResult();
            HistoricVariableInstanceTest.assertNotNull((Object)historicFormUpdate);
            HistoricVariableInstanceTest.assertEquals((String)theStartActivityInstanceId, (String)historicFormUpdate.getActivityInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testSetDifferentStates() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariables(task.getId(), (Map)Variables.createVariables().putValue("bar", (Object)"abc"));
        this.taskService.complete(task.getId());
        this.runtimeService.removeVariable(processInstance.getId(), "bar");
        List variables = this.historyService.createHistoricVariableInstanceQuery().includeDeleted().list();
        Assert.assertEquals((long)2L, (long)variables.size());
        int createdCounter = 0;
        int deletedCounter = 0;
        for (HistoricVariableInstance variable : variables) {
            if (variable.getName().equals("initial")) {
                Assert.assertEquals((Object)"CREATED", (Object)variable.getState());
                ++createdCounter;
                continue;
            }
            if (!variable.getName().equals("bar")) continue;
            Assert.assertEquals((Object)"DELETED", (Object)variable.getState());
            ++deletedCounter;
        }
        Assert.assertEquals((long)1L, (long)createdCounter);
        Assert.assertEquals((long)1L, (long)deletedCounter);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testQueryNotIncludeDeleted() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariables(task.getId(), (Map)Variables.createVariables().putValue("bar", (Object)"abc"));
        this.taskService.complete(task.getId());
        this.runtimeService.removeVariable(processInstance.getId(), "bar");
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"CREATED", (String)variable.getState());
        HistoricVariableInstanceTest.assertEquals((String)"initial", (String)variable.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstanceTest.assertEquals((String)"initial", (String)variable.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionKey() {
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processDefinitionKey("twoTasksProcess").singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstanceTest.assertEquals((String)"initial", (String)variable.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionKeyTwoInstances() {
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo").putValue("vegie", (Object)"cucumber"));
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"bar").putValue("fruit", (Object)"marakuia"));
        List variables = this.historyService.createHistoricVariableInstanceQuery().processDefinitionKey("twoTasksProcess").list();
        HistoricVariableInstanceTest.assertNotNull((Object)variables);
        HistoricVariableInstanceTest.assertEquals((int)4, (int)variables.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionKeyTwoDefinitions() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("initial", (Object)"bar"));
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processDefinitionKey("twoTasksProcess").singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstanceTest.assertEquals((String)"initial", (String)variable.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceIdAndVariableId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("initial", (Object)"bar"));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("initial").singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstance historyVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableId(variable.getId()).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)historyVariable);
        HistoricVariableInstanceTest.assertEquals((String)"initial", (String)historyVariable.getName());
        HistoricVariableInstanceTest.assertEquals((Object)"bar", (Object)historyVariable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testVariableCreateTime() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date fixedDate = sdf.parse("01/01/2001 01:01:01.000");
        ClockUtil.setCurrentTime((Date)fixedDate);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertEquals((Object)fixedDate, (Object)variable.getCreateTime());
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariableNameEqualsIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        variables.put(variableName, "variableValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName.toLowerCase()).singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName.toLowerCase()).matchVariableNamesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchIgnoreCase).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariableValueEqualsIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        String variableValue = "variableValue";
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue).singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue.toLowerCase()).singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue.toLowerCase()).matchVariableValuesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchIgnoreCase).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariableNameAndValueEqualsIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        String variableValue = "variableValue";
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue).singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchNameIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).matchVariableNamesIgnoreCase().singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchValueIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).matchVariableValuesIgnoreCase().singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchNameAndValueIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchNameIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchValueIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchNameAndValueIgnoreCase).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariableNameLikeIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        String variableValue = "variableValue";
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("variableN%").singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("variablen%").singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchNameIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("variablen%").matchVariableNamesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchNameIgnoreCase).isNotNull();
    }

    public static class CustomVar
    implements Serializable {
        private String value;

        public CustomVar(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

