/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricProcessInstancesBatchCmd
implements Command<Batch> {
    protected final String deleteReason;
    protected List<String> historicProcessInstanceIds;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;

    public DeleteHistoricProcessInstancesBatchCmd(List<String> historicProcessInstanceIds, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.deleteReason = deleteReason;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> collectedInstanceIds = this.collectHistoricProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicProcessInstanceIds", collectedInstanceIds);
        return new BatchBuilder(commandContext).type("historic-instance-deletion").config(this.getConfiguration(collectedInstanceIds)).permission(BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected List<String> collectHistoricProcessInstanceIds() {
        HistoricProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.getHistoricProcessInstanceIds();
        if (processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            for (HistoricProcessInstance hpi : processInstanceQuery.list()) {
                collectedProcessInstanceIds.add(hpi.getId());
            }
        }
        return new ArrayList<String>(collectedProcessInstanceIds);
    }

    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logProcessInstanceOperation("DeleteHistory", null, null, null, propertyChanges);
    }

    public BatchConfiguration getConfiguration(Collection<String> instances) {
        return new BatchConfiguration(new ArrayList<String>(instances), false);
    }
}

