/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class DeleteProcessInstanceBatchCmd
implements Command<Batch> {
    protected final String deleteReason;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected boolean skipCustomListeners;
    protected boolean skipSubprocesses;

    public DeleteProcessInstanceBatchCmd(List<String> processInstances, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason, boolean skipCustomListeners, boolean skipSubprocesses) {
        this.processInstanceIds = processInstances;
        this.processInstanceQuery = processInstanceQuery;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.deleteReason = deleteReason;
        this.skipCustomListeners = skipCustomListeners;
        this.skipSubprocesses = skipSubprocesses;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> collectedInstanceIds = this.collectProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", collectedInstanceIds);
        return new BatchBuilder(commandContext).type("instance-deletion").config(this.getConfiguration(collectedInstanceIds)).permission(BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected List<String> collectProcessInstanceIds() {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.getProcessInstanceIds();
        if (processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.processInstanceQuery) != null) {
            collectedProcessInstanceIds.addAll(processInstanceQuery.listIds());
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            collectedProcessInstanceIds.addAll(historicProcessInstanceQuery.listIds());
        }
        return new ArrayList<String>(collectedProcessInstanceIds);
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", null, null, null, propertyChanges);
    }

    public BatchConfiguration getConfiguration(Collection<String> instanceIds) {
        return new DeleteProcessInstanceBatchConfiguration(new ArrayList<String>(instanceIds), this.deleteReason, this.skipCustomListeners, this.skipSubprocesses, false);
    }
}

