/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricDecisionInstancesBatchCmd
implements Command<Batch> {
    protected List<String> historicDecisionInstanceIds;
    protected HistoricDecisionInstanceQuery historicDecisionInstanceQuery;
    protected String deleteReason;

    public DeleteHistoricDecisionInstancesBatchCmd(List<String> ids, HistoricDecisionInstanceQuery query, String deleteReason) {
        this.historicDecisionInstanceIds = ids;
        this.historicDecisionInstanceQuery = query;
        this.deleteReason = deleteReason;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> collectedInstanceIds = this.collectHistoricDecisionInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicDecisionInstanceIds", collectedInstanceIds);
        return new BatchBuilder(commandContext).type("historic-decision-instance-deletion").config(this.getConfiguration(collectedInstanceIds)).permission(BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected List<String> collectHistoricDecisionInstanceIds() {
        HistoricDecisionInstanceQueryImpl decisionInstanceQuery;
        HashSet<String> collectedDecisionInstanceIds = new HashSet<String>();
        List<String> decisionInstanceIds = this.getHistoricDecisionInstanceIds();
        if (decisionInstanceIds != null) {
            collectedDecisionInstanceIds.addAll(decisionInstanceIds);
        }
        if ((decisionInstanceQuery = (HistoricDecisionInstanceQueryImpl)this.historicDecisionInstanceQuery) != null) {
            for (HistoricDecisionInstance hdi : decisionInstanceQuery.list()) {
                collectedDecisionInstanceIds.add(hdi.getId());
            }
        }
        return new ArrayList<String>(collectedDecisionInstanceIds);
    }

    public List<String> getHistoricDecisionInstanceIds() {
        return this.historicDecisionInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("DeleteHistory", propertyChanges);
    }

    public BatchConfiguration getConfiguration(Collection<String> instances) {
        return new BatchConfiguration(new ArrayList<String>(instances));
    }
}

