/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.batch;

import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.AbstractMigrationCmd;
import org.camunda.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class MigrateProcessInstanceBatchCmd
extends AbstractMigrationCmd
implements Command<Batch> {
    public MigrateProcessInstanceBatchCmd(MigrationPlanExecutionBuilderImpl builder) {
        super(builder);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        Collection<String> collectedInstanceIds = this.collectProcessInstanceIds();
        MigrationPlan migrationPlan = this.executionBuilder.getMigrationPlan();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot empty", "process instance ids", collectedInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "process instance ids", collectedInstanceIds);
        ProcessDefinitionEntity sourceDefinition = this.resolveSourceProcessDefinition(commandContext);
        ProcessDefinitionEntity targetDefinition = this.resolveTargetProcessDefinition(commandContext);
        String tenantId = sourceDefinition.getTenantId();
        return new BatchBuilder(commandContext).type("instance-migration").config(this.getConfiguration(collectedInstanceIds)).permission(BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES).permissionHandler(ctx -> this.checkAuthorizations(ctx, sourceDefinition, targetDefinition)).tenantId(tenantId).operationLogHandler((ctx, instanceCount) -> this.writeUserOperationLog(ctx, sourceDefinition, targetDefinition, instanceCount, true)).build();
    }

    public BatchConfiguration getConfiguration(Collection<String> instanceIds) {
        return new MigrationBatchConfiguration(new ArrayList<String>(instanceIds), this.executionBuilder.getMigrationPlan(), this.executionBuilder.isSkipCustomListeners(), this.executionBuilder.isSkipIoMappings());
    }
}

