/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.optimize;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class OptimizeServiceAuthorizationTest {
    public static final String TEST_DECISION = "testDecision";
    public static final String SIMPLE_PROCESS = "process";
    public static final String USER_TASK_PROCESS = "userTaskProcess";
    private OptimizeService optimizeService;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected String userId = "test";
    public static final String DECISION_INPUT_EQUALS_OUTPUT = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public Function<OptimizeService, List<?>> methodToTest;
    protected IdentityService identityService;
    protected RepositoryService repositoryService;
    protected AuthorizationService authorizationService;
    protected RuntimeService runtimeService;
    protected DecisionService decisionService;
    protected TaskService taskService;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getCompletedHistoricActivityInstances(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getRunningHistoricActivityInstances(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getCompletedHistoricProcessInstances(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getRunningHistoricProcessInstances(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getCompletedHistoricTaskInstances(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getRunningHistoricTaskInstances(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getHistoricIdentityLinkLogs(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getHistoricUserOperationLogs(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getHistoricVariableUpdates(new Date(0L), null, 10);
            }
        }}, {new Function<OptimizeService, List<?>>(){

            @Override
            public List<?> apply(OptimizeService optimizeService) {
                return optimizeService.getHistoricDecisionInstances(new Date(0L), null, 10);
            }
        }});
    }

    @Before
    public void setUp() throws Exception {
        this.identityService = this.engineRule.getIdentityService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.decisionService = this.engineRule.getDecisionService();
        this.taskService = this.engineRule.getTaskService();
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        this.authRule.createUserAndGroup(this.userId, "testGroup");
        this.authRule.createGrantAuthorization((Resource)Resources.AUTHORIZATION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.authRule.createGrantAuthorization((Resource)Resources.USER, "*", this.userId, new Permission[]{Permissions.ALL});
        this.deployTestData();
        this.authRule.enableAuthorization(this.userId);
    }

    @After
    public void tearDown() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
        this.authRule.disableAuthorization();
        this.authRule.deleteUsersAndGroups();
        this.identityService.clearAuthentication();
    }

    @Test
    public void cantGetDataWithoutTenantAuthorization() {
        this.identityService.setAuthentication(this.userId, null, Collections.singletonList(TENANT_ONE));
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        try {
            this.methodToTest.apply(this.optimizeService);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve the data");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.testRule.assertTextPresent(this.userId, exceptionMessage);
            this.testRule.assertTextPresent(Permissions.READ.getName(), exceptionMessage);
            this.testRule.assertTextPresent(Resources.TENANT.resourceName(), exceptionMessage);
        }
    }

    @Test
    public void cantGetDataWithoutProcessDefinitionAuthorization() {
        this.identityService.setAuthentication(this.userId, null, Collections.singletonList(TENANT_ONE));
        this.authRule.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.TENANT, "*", this.userId, new Permission[]{Permissions.READ});
        try {
            this.methodToTest.apply(this.optimizeService);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve the data");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.testRule.assertTextPresent(this.userId, exceptionMessage);
            this.testRule.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    @Test
    public void authorizationOnSingleProcessResourceNotEnough() {
        this.identityService.setAuthentication(this.userId, null, Collections.singletonList(TENANT_ONE));
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIMPLE_PROCESS, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.TENANT, "*", this.userId, new Permission[]{Permissions.READ});
        try {
            this.methodToTest.apply(this.optimizeService);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve the data");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.testRule.assertTextPresent(this.userId, exceptionMessage);
            this.testRule.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    @Test
    public void cantGetDataWithoutDecisionDefinitionAuthorization() {
        this.identityService.setAuthentication(this.userId, null, Collections.singletonList(TENANT_ONE));
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.TENANT, "*", this.userId, new Permission[]{Permissions.READ});
        try {
            this.methodToTest.apply(this.optimizeService);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve the data");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.testRule.assertTextPresent(this.userId, exceptionMessage);
            this.testRule.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.testRule.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    @Test
    public void authorizationOnSingleDecisionResourceNotEnough() {
        this.identityService.setAuthentication(this.userId, null, Collections.singletonList(TENANT_ONE));
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, TEST_DECISION, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.TENANT, "*", this.userId, new Permission[]{Permissions.READ});
        try {
            this.methodToTest.apply(this.optimizeService);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve the data");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.testRule.assertTextPresent(this.userId, exceptionMessage);
            this.testRule.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.testRule.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    @Test
    public void canGetDataWithAllAuthorizations() {
        this.identityService.setAuthentication(this.userId, null, Collections.singletonList(TENANT_ONE));
        this.generateTestData();
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.TENANT, "*", this.userId, new Permission[]{Permissions.READ});
        List<?> instance = this.methodToTest.apply(this.optimizeService);
        MatcherAssert.assertThat((Object)instance.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private void generateTestData() {
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(false);
        ProcessDefinition process = this.selectProcessDefinitionByKey(SIMPLE_PROCESS);
        this.runtimeService.startProcessInstanceById(process.getId(), (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        ProcessDefinition process2 = this.selectProcessDefinitionByKey(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceById(process2.getId());
        this.completeAllUserTasks();
        DecisionDefinition decision = this.selectDecisionDefinitionByKey();
        this.decisionService.evaluateDecisionById(decision.getId()).variables((Map)Variables.createVariables().putValue("input1", (Object)"a")).evaluate();
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(true);
    }

    private void completeAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
            this.taskService.complete(task.getId());
        }
    }

    protected ProcessDefinition selectProcessDefinitionByKey(String processDefinitionKey) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
    }

    protected DecisionDefinition selectDecisionDefinitionByKey() {
        return (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(TEST_DECISION).singleResult();
    }

    private void deployTestData() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().tenantId(TENANT_ONE);
        BpmnModelInstance bpmnModelInstance = Bpmn.createExecutableProcess((String)SIMPLE_PROCESS).startEvent().endEvent().done();
        deploymentBuilder.addModelInstance("testProcess1-.bpmn", bpmnModelInstance);
        bpmnModelInstance = Bpmn.createExecutableProcess((String)USER_TASK_PROCESS).startEvent().userTask().userTask().endEvent().done();
        deploymentBuilder.addModelInstance("userTaskProcess1-.bpmn", bpmnModelInstance);
        deploymentBuilder.addClasspathResource(DECISION_INPUT_EQUALS_OUTPUT);
        this.testRule.deploy(deploymentBuilder);
        deploymentBuilder = this.repositoryService.createDeployment().tenantId(TENANT_TWO);
        deploymentBuilder.addModelInstance("testProcess2-.bpmn", bpmnModelInstance);
        deploymentBuilder.addClasspathResource(DECISION_INPUT_EQUALS_OUTPUT);
        this.testRule.deploy(deploymentBuilder);
    }

    private static interface Function<T, T1> {
        public T1 apply(T var1);
    }
}

