/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.history.removaltime.AbstractRemovalTimeTest;
import org.camunda.bpm.engine.test.api.history.removaltime.FailingExecutionListener;
import org.camunda.bpm.engine.test.bpmn.async.FailingDelegate;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Test;

public class RemovalTimeStrategyStartTest
extends AbstractRemovalTimeTest {
    protected final String CALLED_PROCESS_KEY = "calledProcess";
    protected final BpmnModelInstance CALLED_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().userTask("userTask").name("userTask")).camundaCandidateUsers("foo")).serviceTask().camundaAsyncBefore()).camundaClass(FailingDelegate.class.getName())).endEvent().done();
    protected final String CALLING_PROCESS_KEY = "callingProcess";
    protected final BpmnModelInstance CALLING_PROCESS = ((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done();
    protected final Date START_DATE = new Date(1363608000000L);

    @Before
    public void setUp() {
        processEngineConfiguration.setHistoryRemovalTimeStrategy("start").setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).initHistoryRemovalTime();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveStandaloneHistoricDecisionInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("dish-decision").singleResult();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(5));
        this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionInputInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveStandaloneHistoricDecisionInputInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("dish-decision").singleResult();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(5));
        this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotResolveHistoricDecisionInputInstance() {
        this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionOutputInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveStandaloneHistoricDecisionOutputInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotResolveHistoricDecisionOutputInstance() {
        this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveHistoricProcessInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult();
        MatcherAssert.assertThat((Object)historicProcessInstance, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)historicProcessInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricActivityInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        MatcherAssert.assertThat((Object)historicActivityInstance, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)historicActivityInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricTaskInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult();
        MatcherAssert.assertThat((Object)historicTaskInstance, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)historicTaskInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricTaskAuthorization() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("myUserId");
        authorization.setResource((Resource)Resources.HISTORIC_TASK);
        authorization.setResourceId(taskId);
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        this.clearAuthorization();
    }

    @Test
    public void shouldResetAuthorizationAfterUpdate() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.enabledAuth();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.disableAuth();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.clearAuthorization();
    }

    @Test
    public void shouldResolveAuthorizationAfterUpdate() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_TASK);
        authorization.setResourceId("*");
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        authorization.setResourceId(taskId);
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        this.clearAuthorization();
    }

    @Test
    public void shouldWriteHistoryAndResolveHistoricTaskAuthorizationInDifferentTransactions() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.enabledAuth();
        this.taskService.setAssignee(taskId, "myUserId");
        this.disableAuth();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        this.clearAuthorization();
    }

    @Test
    public void shouldWriteHistoryAndResolveHistoricTaskAuthorizationInSameTransaction() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.enabledAuth();
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.disableAuth();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "myUserId");
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        this.clearAuthorization();
    }

    @Test
    public void shouldNotResolveHistoricTaskInstance() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        MatcherAssert.assertThat((Object)historicTaskInstance, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicTaskInstance.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void shouldResolveVariableInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)historicVariableInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricDetailByVariableInstanceUpdate() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        MatcherAssert.assertThat((Object)historicDetails.size(), (Matcher)Is.is((Object)2));
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricDetailByFormProperty() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        String processDefinitionId = ((ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0)).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("aFormProperty", "aFormPropertyValue");
        this.formService.submitStartForm(processDefinitionId, properties);
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().formFields().singleResult();
        MatcherAssert.assertThat((Object)historicDetail, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)historicDetail.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveIncident() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)historicIncidents.size(), (Matcher)Is.is((Object)2));
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveStandaloneIncident() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.repositoryService.suspendProcessDefinitionByKey("calledProcess", true, new Date(1363608000000L));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.clearJobLog(jobId);
        this.clearHistoricIncident(historicIncident);
    }

    @Test
    public void shouldResolveExternalTaskLog() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricExternalTaskLog externalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        MatcherAssert.assertThat((Object)externalTaskLog, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)externalTaskLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveJobLog() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List jobLog = this.historyService.createHistoricJobLogQuery().list();
        MatcherAssert.assertThat((Object)jobLog.size(), (Matcher)Is.is((Object)2));
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveJobLog() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.repositoryService.suspendProcessDefinitionByKey("calledProcess", true, new Date(1363608000000L));
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.managementService.deleteJob(jobLog.getJobId());
        this.clearJobLog(jobLog.getJobId());
    }

    @Test
    public void shouldResolveUserOperationLog_SetJobRetries() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.managementService.setJobRetries(jobId, 65);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveUserOperationLog_SetExternalTaskRetries() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.identityService.setAuthenticatedUserId("aUserId");
        this.externalTaskService.setRetries(((ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult()).getId(), 65);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveUserOperationLog_ClaimTask() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.identityService.setAuthenticatedUserId("aUserId");
        this.taskService.claim(((Task)this.taskService.createTaskQuery().singleResult()).getId(), "aUserId");
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveUserOperationLog_CreateAttachment() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.identityService.setAuthenticatedUserId("aUserId");
        this.taskService.createAttachment(null, null, ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId(), null, null, "http://camunda.com");
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveIdentityLink_AddCandidateUser() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "aUserId");
        HistoricIdentityLinkLog historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().userId("aUserId").singleResult();
        MatcherAssert.assertThat((Object)historicIdentityLinkLog, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveIdentityLink_AddCandidateUser() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Task aTask = this.taskService.newTask();
        this.taskService.saveTask(aTask);
        this.taskService.addCandidateUser(aTask.getId(), "aUserId");
        HistoricIdentityLinkLog historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIdentityLinkLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.taskService.complete(aTask.getId());
        this.clearHistoricTaskInst(aTask.getId());
    }

    @Test
    public void shouldResolveCommentByProcessInstanceId() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment(null, processInstanceId, "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveCommentByTaskId() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.createComment(taskId, null, "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveCommentByWrongTaskIdAndProcessInstanceId() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment("aNonExistentTaskId", processInstanceId, "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveCommentByTaskIdAndWrongProcessInstanceId() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.createComment(taskId, "aNonExistentProcessInstanceId", "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveCommentByWrongProcessInstanceId() {
        this.taskService.createComment(null, "aNonExistentProcessInstanceId", "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments("aNonExistentProcessInstanceId").get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.clearCommentByProcessInstanceId("aNonExistentProcessInstanceId");
    }

    @Test
    public void shouldNotResolveCommentByWrongTaskId() {
        this.taskService.createComment("aNonExistentTaskId", null, "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments("aNonExistentTaskId").get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.clearCommentByTaskId("aNonExistentTaskId");
    }

    @Test
    public void shouldResolveAttachmentByProcessInstanceId() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveAttachmentByTaskId() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, taskId, null, null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveAttachmentByWrongTaskIdAndProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, "aWrongTaskId", processInstanceId, null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveAttachmentByTaskIdAndWrongProcessInstanceId() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, taskId, "aWrongProcessInstanceId", null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveAttachmentByWrongTaskId() {
        String attachmentId = this.taskService.createAttachment(null, "aWrongTaskId", null, null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.clearAttachment(attachment);
    }

    @Test
    public void shouldResolveByteArray_CreateAttachmentByTask() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, taskId, null, null, null, (InputStream)new ByteArrayInputStream("hello world".getBytes()));
        ByteArrayEntity byteArray = this.findByteArrayById(attachment.getContentId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_CreateAttachmentByProcessInstance() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String calledProcessInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, null, calledProcessInstanceId, null, null, (InputStream)new ByteArrayInputStream("hello world".getBytes()));
        ByteArrayEntity byteArray = this.findByteArrayById(attachment.getContentId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_SetVariable() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)new ByteArrayInputStream("hello world".getBytes()));
        HistoricVariableInstanceEntity historicVariableInstance = (HistoricVariableInstanceEntity)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(historicVariableInstance.getByteArrayId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_UpdateVariable() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)new ByteArrayInputStream("hello world".getBytes()));
        HistoricDetailVariableInstanceUpdateEntity historicDetails = (HistoricDetailVariableInstanceUpdateEntity)this.historyService.createHistoricDetailQuery().variableUpdates().variableTypeIn(new String[]{"Bytes"}).singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(historicDetails.getByteArrayValueId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_JobLog() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogEventEntity jobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().jobExceptionMessage("I'm supposed to fail!").singleResult();
        MatcherAssert.assertThat((Object)jobLog, (Matcher)IsNull.notNullValue());
        ByteArrayEntity byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_ExternalTaskLog() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("aTopicName")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, "aWorkerId").topic("aTopicName", Integer.MAX_VALUE).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)tasks.get(0)).getId(), "aWorkerId", null, "errorDetails", 5, 3000L);
        HistoricExternalTaskLogEntity externalTaskLog = (HistoricExternalTaskLogEntity)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        MatcherAssert.assertThat((Object)externalTaskLog, (Matcher)IsNull.notNullValue());
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(externalTaskLog.getErrorDetailsByteArrayId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_DecisionInput() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("testDecision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionInputInstanceEntity historicDecisionInputInstanceEntity = (HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionInputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_StandaloneDecisionInput() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").singleResult();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(5));
        this.decisionService.evaluateDecisionTableByKey("testDecision", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionInputInstanceEntity historicDecisionInputInstanceEntity = (HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionInputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_DecisionOutput() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("testDecision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_StandaloneDecisionOutput() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").singleResult();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(5));
        this.decisionService.evaluateDecisionTableByKey("testDecision", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/HistoricRootProcessInstanceTest.shouldResolveByteArray_DecisionOutputLiteralExpression.dmn"})
    public void shouldResolveByteArray_DecisionOutputLiteralExpression() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("testDecision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/HistoricRootProcessInstanceTest.shouldResolveByteArray_DecisionOutputLiteralExpression.dmn"})
    public void shouldResolveByteArray_StandaloneDecisionOutputLiteralExpression() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").singleResult();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(5));
        this.decisionService.evaluateDecisionTableByKey("testDecision", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.START_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveBatch() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        MatcherAssert.assertThat((Object)historicBatch.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        String seedJobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(seedJobId);
        String jobId = ((Job)this.managementService.createJobQuery().list().get(0)).getId();
        this.managementService.executeJob(jobId);
        String monitorJobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(monitorJobId);
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        MatcherAssert.assertThat((Object)historicBatch.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.historyService.deleteHistoricBatch(batch.getId());
    }

    @Test
    public void shouldResolveBatchJobLog() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.executeJob(jobLog.getJobId());
        List jobLogs = this.historyService.createHistoricJobLogQuery().list();
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(0)).getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(1)).getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldResolveBatchJobLog_ByteArray() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        FailingExecutionListener.shouldFail = true;
        this.testRule.deploy(((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaExecutionListenerClass("end", FailingExecutionListener.class)).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
            }
            catch (RuntimeException runtimeException) {}
        }
        HistoricJobLogEventEntity jobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String byteArrayId = jobLog.getExceptionByteArrayId();
        ByteArrayEntity byteArray = this.findByteArrayById(byteArrayId);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.deleteBatch(batch.getId(), true);
        FailingExecutionListener.shouldFail = false;
    }

    @Test
    public void shouldResolveBatchIncident_SeedJob() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.setJobRetries(jobLog.getJobId(), 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldResolveBatchIncident_BatchJob() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.runtimeService.deleteProcessInstance(processInstanceId, "aDeleteReason");
        this.managementService.executeJob(jobLog.getJobId());
        String jobId = ((Job)this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldResolveBatchIncident_MonitorJob() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.executeJob(jobLog.getJobId());
        String jobId = ((Job)this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.managementService.deleteBatch(batch.getId(), true);
    }
}

