/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.batch.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.bpmn.async.FailingExecutionListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class BatchSetRemovalTimeRule
extends TestWatcher {
    protected ProcessEngineRule engineRule;
    protected ProcessEngineTestRule engineTestRule;
    public final Date CURRENT_DATE = new Date(1363608000000L);
    public final Date REMOVAL_TIME = new Date(1363609000000L);
    protected List<String> batchIds = new ArrayList<String>();

    public BatchSetRemovalTimeRule(ProcessEngineRule engineRule, ProcessEngineTestRule engineTestRule) {
        this.engineRule = engineRule;
        this.engineTestRule = engineTestRule;
    }

    protected void starting(Description description) {
        this.getProcessEngineConfiguration().setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        ClockUtil.setCurrentTime((Date)this.CURRENT_DATE);
        super.starting(description);
    }

    protected void finished(Description description) {
        this.getProcessEngineConfiguration().setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null).initHistoryRemovalTime();
        this.getProcessEngineConfiguration().setBatchOperationHistoryTimeToLive(null);
        this.getProcessEngineConfiguration().setBatchOperationsForHistoryCleanup(null);
        this.getProcessEngineConfiguration().setBatchOperationHistoryTimeToLive(null);
        this.getProcessEngineConfiguration().setHistoryCleanupStrategy(null);
        this.getProcessEngineConfiguration().initHistoryCleanup();
        this.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        this.getProcessEngineConfiguration().setDmnEnabled(true);
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
        ClockUtil.reset();
        this.clearDatabase();
        this.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        this.getProcessEngineConfiguration().setAuthorizationEnabled(false);
        super.finished(description);
    }

    public void clearDatabase() {
        if (!this.batchIds.isEmpty()) {
            for (String batchId : this.batchIds) {
                HistoricBatch historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().batchId(batchId).singleResult();
                if (historicBatch == null) continue;
                this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
            }
        }
    }

    public TestProcessBuilder process() {
        return new TestProcessBuilder();
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.engineRule.getProcessEngineConfiguration();
    }

    public void updateHistoryTimeToLive(String key, int ttl) {
        this.updateHistoryTimeToLive(ttl, key);
    }

    public void updateHistoryTimeToLive(int ttl, String ... keys) {
        for (String key : keys) {
            String processDefinitionId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).singleResult()).getId();
            this.engineRule.getRepositoryService().updateProcessDefinitionHistoryTimeToLive(processDefinitionId, Integer.valueOf(ttl));
        }
    }

    public void updateHistoryTimeToLiveDmn(String key, int ttl) {
        this.updateHistoryTimeToLiveDmn(ttl, key);
    }

    public void updateHistoryTimeToLiveDmn(int ttl, String ... keys) {
        for (String key : keys) {
            String decisionDefinitionId = ((DecisionDefinition)this.engineRule.getRepositoryService().createDecisionDefinitionQuery().decisionDefinitionKey(key).singleResult()).getId();
            this.engineRule.getRepositoryService().updateDecisionDefinitionHistoryTimeToLive(decisionDefinitionId, Integer.valueOf(ttl));
        }
    }

    public void enableAuth() {
        this.getProcessEngineConfiguration().setAuthorizationEnabled(true);
    }

    public void disableAuth() {
        this.getProcessEngineConfiguration().setAuthorizationEnabled(false);
    }

    public void clearAuthorization() {
        this.engineRule.getAuthorizationService().createAuthorizationQuery().list().forEach(authorization -> this.engineRule.getAuthorizationService().deleteAuthorization(authorization.getId()));
    }

    public void syncExec(Batch batch) {
        this.syncExec(batch, true);
    }

    public void syncExec(Batch batch, boolean isClear) {
        if (isClear) {
            this.batchIds.add(batch.getId());
        }
        this.executeSeedJobs(batch);
        List<Job> jobs = this.getExecutionJobs(batch);
        for (Job job : jobs) {
            this.engineRule.getManagementService().executeJob(job.getId());
        }
        this.engineRule.getManagementService().executeJob(this.getJobForDefinition(batch.getMonitorJobDefinitionId()).getId());
    }

    public void executeSeedJobs(Batch batch) {
        while (this.getSeedJob(batch) != null) {
            this.engineRule.getManagementService().executeJob(this.getSeedJob(batch).getId());
        }
    }

    public Job getSeedJob(Batch batch) {
        return this.getJobForDefinition(batch.getSeedJobDefinitionId());
    }

    protected Job getJobForDefinition(String definitionId) {
        return (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(definitionId).singleResult();
    }

    public List<Job> getExecutionJobs(Batch batch) {
        List jobs = this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list();
        return jobs;
    }

    public static Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }

    public ByteArrayEntity findByteArrayById(String byteArrayId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        return (ByteArrayEntity)commandExecutor.execute((Command)new GetByteArrayCommand(byteArrayId));
    }

    public class TestProcessBuilder {
        protected static final String PROCESS_KEY = "process";
        protected static final String ROOT_PROCESS_KEY = "rootProcess";
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)"process");
        StartEventBuilder startEventBuilder = this.builder.startEvent();
        ProcessBuilder rootProcessBuilder = null;
        Integer ttl;
        CallActivityBuilder callActivityBuilder;

        public TestProcessBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public TestProcessBuilder async() {
            this.startEventBuilder.camundaAsyncBefore();
            return this;
        }

        public TestProcessBuilder ruleTask(String ref) {
            this.startEventBuilder.businessRuleTask().camundaDecisionRef(ref);
            return this;
        }

        public TestProcessBuilder call() {
            this.rootProcessBuilder = Bpmn.createExecutableProcess((String)ROOT_PROCESS_KEY);
            this.callActivityBuilder = (CallActivityBuilder)this.rootProcessBuilder.startEvent().callActivity().calledElement(PROCESS_KEY);
            return this;
        }

        public TestProcessBuilder passVars(String ... vars) {
            for (String variable : vars) {
                this.callActivityBuilder.camundaIn(variable, variable);
            }
            this.callActivityBuilder.endEvent();
            return this;
        }

        public TestProcessBuilder userTask() {
            ((UserTaskBuilder)this.startEventBuilder.userTask("userTask").name("userTask")).camundaAssignee("anAssignee");
            return this;
        }

        public TestProcessBuilder scriptTask() {
            ((ScriptTaskBuilder)this.startEventBuilder.scriptTask().scriptFormat("groovy")).scriptText("throw new RuntimeException()");
            return this;
        }

        public TestProcessBuilder externalTask() {
            this.startEventBuilder.serviceTask().camundaExternalTask("aTopicName");
            return this;
        }

        public TestProcessBuilder serviceTask() {
            this.startEventBuilder.serviceTask().camundaExpression("${true}");
            return this;
        }

        public TestProcessBuilder failingCustomListener() {
            this.startEventBuilder.userTask().camundaExecutionListenerClass("end", FailingExecutionListener.class);
            return this;
        }

        public TestProcessBuilder deploy() {
            if (this.ttl != null) {
                if (this.rootProcessBuilder != null) {
                    this.rootProcessBuilder.camundaHistoryTimeToLive(this.ttl);
                } else {
                    this.builder.camundaHistoryTimeToLive(this.ttl);
                }
            }
            BpmnModelInstance process = this.startEventBuilder.endEvent().done();
            BatchSetRemovalTimeRule.this.engineTestRule.deploy(process);
            if (this.rootProcessBuilder != null) {
                BatchSetRemovalTimeRule.this.engineTestRule.deploy(this.rootProcessBuilder.done());
            }
            return this;
        }

        public String start() {
            return this.startWithVariables(null);
        }

        public String startWithVariables(Map<String, Object> variables) {
            String key = null;
            key = this.rootProcessBuilder != null ? ROOT_PROCESS_KEY : PROCESS_KEY;
            return BatchSetRemovalTimeRule.this.engineRule.getRuntimeService().startProcessInstanceByKey(key, variables).getId();
        }
    }
}

