/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class PropertyUserOperationLogTest {
    private static final String USER_ID = "testUserId";
    private static final String PROPERTY_NAME = "TEST_PROPERTY";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.managementService = this.engineRule.getManagementService();
    }

    @After
    public void tearDown() {
        this.managementService.deleteProperty(PROPERTY_NAME);
    }

    @Test
    public void testCreateProperty() {
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setProperty(PROPERTY_NAME, "testValue");
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertThat((Object)entry.getEntityType(), (Matcher)CoreMatchers.is((Object)"Property"));
        Assert.assertThat((Object)entry.getCategory(), (Matcher)CoreMatchers.is((Object)"Admin"));
        Assert.assertThat((Object)entry.getOperationType(), (Matcher)CoreMatchers.is((Object)"Create"));
        Assert.assertThat((Object)entry.getProperty(), (Matcher)CoreMatchers.is((Object)"name"));
        Assert.assertThat((Object)entry.getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)entry.getNewValue(), (Matcher)CoreMatchers.is((Object)PROPERTY_NAME));
    }

    @Test
    public void testUpdateProperty() {
        this.managementService.setProperty(PROPERTY_NAME, "testValue");
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setProperty(PROPERTY_NAME, "testValue2");
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertThat((Object)entry.getEntityType(), (Matcher)CoreMatchers.is((Object)"Property"));
        Assert.assertThat((Object)entry.getCategory(), (Matcher)CoreMatchers.is((Object)"Admin"));
        Assert.assertThat((Object)entry.getOperationType(), (Matcher)CoreMatchers.is((Object)"Update"));
        Assert.assertThat((Object)entry.getProperty(), (Matcher)CoreMatchers.is((Object)"name"));
        Assert.assertThat((Object)entry.getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)entry.getNewValue(), (Matcher)CoreMatchers.is((Object)PROPERTY_NAME));
    }

    @Test
    public void testDeleteProperty() {
        this.managementService.setProperty(PROPERTY_NAME, "testValue");
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.deleteProperty(PROPERTY_NAME);
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertThat((Object)entry.getEntityType(), (Matcher)CoreMatchers.is((Object)"Property"));
        Assert.assertThat((Object)entry.getCategory(), (Matcher)CoreMatchers.is((Object)"Admin"));
        Assert.assertThat((Object)entry.getOperationType(), (Matcher)CoreMatchers.is((Object)"Delete"));
        Assert.assertThat((Object)entry.getProperty(), (Matcher)CoreMatchers.is((Object)"name"));
        Assert.assertThat((Object)entry.getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)entry.getNewValue(), (Matcher)CoreMatchers.is((Object)PROPERTY_NAME));
    }

    @Test
    public void testDeletePropertyNonExisting() {
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.deleteProperty(PROPERTY_NAME);
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
    }
}

