/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.license;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LicenseKeyAuthTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected ExpectedException exceptionRule = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.exceptionRule);
    protected ProcessEngine processEngine;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ManagementService managementService;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;

    @Before
    public void init() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        this.managementService = this.processEngine.getManagementService();
        this.identityService = this.processEngine.getIdentityService();
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.clearAuthentication();
        this.removeAdminUser();
    }

    @Test
    public void shouldGetLicenseKeyWithAuthorizedAdmin() {
        this.authenticateAdminUser();
        this.managementService.getLicenseKey();
    }

    @Test
    public void shouldThrowExceptionWhenGetLicenseKeyWithAuthorizedNonAdmin() {
        this.authenticateUser();
        this.exceptionRule.expect(AuthorizationException.class);
        this.exceptionRule.expectMessage("Required admin authenticated group or user.");
        this.managementService.getLicenseKey();
    }

    @Test
    public void shouldDeleteLicenseKeyWithAuthorizedAdmin() {
        this.authenticateAdminUser();
        this.managementService.deleteLicenseKey();
    }

    @Test
    public void shouldThrowExceptionWhenDeleteLicenseKeyWithAuthorizedNonAdmin() {
        this.authenticateUser();
        this.exceptionRule.expect(AuthorizationException.class);
        this.exceptionRule.expectMessage("Required admin authenticated group or user.");
        this.managementService.deleteLicenseKey();
    }

    protected void authenticateAdminUser() {
        this.processEngineConfiguration.getAdminUsers().add("user");
        this.authenticateUser();
    }

    protected void authenticateUser() {
        this.identityService.setAuthentication("user", null, null);
    }

    protected void removeAdminUser() {
        this.processEngineConfiguration.getAdminUsers().remove("user");
    }
}

