/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.history;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MultiInstanceProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationHistoricVariablesTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    protected static final BpmnModelInstance ONE_BOUNDARY_TASK = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent().message("Message")).done();
    protected static final BpmnModelInstance CONCURRENT_BOUNDARY_TASKS = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent().message("Message")).moveToActivity("userTask2").boundaryEvent().message("Message")).done();
    protected static final BpmnModelInstance SUBPROCESS_CONCURRENT_BOUNDARY_TASKS = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS).activityBuilder("userTask1").boundaryEvent().message("Message")).moveToActivity("userTask2").boundaryEvent().message("Message")).done();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
        this.historyService = this.rule.getHistoryService();
        this.managementService = this.rule.getManagementService();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void noHistoryUpdateOnSameStructureMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_BOUNDARY_TASK);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_BOUNDARY_TASK);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree scopeExecution = executionTreeBeforeMigration.getExecutions().get(0);
        this.runtimeService.setVariableLocal(scopeExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void noHistoryUpdateOnAddScopeMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CONCURRENT_BOUNDARY_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(SUBPROCESS_CONCURRENT_BOUNDARY_TASKS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0).getParent();
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testMigrateHistoryVariableInstance() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        this.runtimeService.setVariable(processInstance.getId(), "test", (Object)3537);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        HistoricVariableInstance migratedInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)targetDefinition.getKey(), (Object)migratedInstance.getProcessDefinitionKey());
        Assert.assertEquals((Object)targetDefinition.getId(), (Object)migratedInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)instance.getActivityInstanceId(), (Object)migratedInstance.getActivityInstanceId());
        Assert.assertEquals((Object)instance.getExecutionId(), (Object)migratedInstance.getExecutionId());
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testMigrateHistoryVariableInstanceMultiInstance() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.PAR_MI_SUBPROCESS_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.PAR_MI_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        List migratedVariables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)6L, (long)migratedVariables.size());
        for (HistoricVariableInstance variable : migratedVariables) {
            Assert.assertEquals((Object)targetDefinition.getKey(), (Object)variable.getProcessDefinitionKey());
            Assert.assertEquals((Object)targetDefinition.getId(), (Object)variable.getProcessDefinitionId());
        }
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testMigrateEventScopeVariable() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "subProcess").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        Execution subProcessExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("userTask1").singleResult();
        this.runtimeService.setVariableLocal(subProcessExecution.getId(), "foo", (Object)"bar");
        this.testHelper.completeTask("userTask1");
        Execution eventScopeExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subProcess").singleResult();
        HistoricVariableInstance eventScopeVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{eventScopeExecution.getId()}).singleResult();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{processInstance.getId()}).execute();
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableId(eventScopeVariable.getId()).singleResult();
        Assert.assertEquals((Object)targetDefinition.getId(), (Object)historicVariableInstance.getProcessDefinitionId());
    }

    @Test
    @Ignore
    @RequiredHistoryLevel(value="audit")
    public void testMigrateHistoricVariablesAsyncBeforeStartEvent() {
        String userTask = "task";
        BpmnModelInstance failing = ((ServiceTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent("startEvent").camundaAsyncBefore(true)).serviceTask("failing").camundaClass("foo")).userTask(userTask).endEvent("endEvent").done();
        BpmnModelInstance passing = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent("startEvent").camundaAsyncBefore(true)).userTask(userTask).endEvent("endEvent").done();
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(failing);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(passing);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceDefinition.getId(), (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.executeJob(job);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("startEvent", "startEvent").mapActivities(userTask, userTask).build();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getRetries());
        this.managementService.setJobRetries(job.getId(), 1);
        this.executeJob((Job)this.managementService.createJobQuery().singleResult());
        Assert.assertNull((Object)this.managementService.createJobQuery().singleResult());
        Assert.assertNotNull((Object)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{userTask}).singleResult());
    }

    protected void executeJob(Job job) {
        ManagementService managementService = this.rule.getManagementService();
        while (job != null && job.getRetries() > 0) {
            try {
                managementService.executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)managementService.createJobQuery().jobId(job.getId()).singleResult();
        }
    }
}

