/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.error.ThrowErrorDelegate;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ErrorEventSubProcessTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testEventSubprocessTakesPrecedence() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testErrorCodeTakesPrecedence() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        ErrorEventSubProcessTest.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterErrorCatch2").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testCatchErrorInEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInEmbeddedSubProcessWithErrorCode() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInEmbeddedSubProcessWithErrorCode").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInsideSubProcessInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInsideSubProcessInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    public void testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        ErrorEventSubProcessTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)userTask);
        ErrorEventSubProcessTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    private void assertThatErrorHasBeenCaught(String procId) {
        ErrorEventSubProcessTest.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testCatchErrorEventSubprocessSetErrorVariables() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorCode";
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assert.assertThat((Object)errorVariable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String errorCode = "error";
        Assert.assertThat((Object)errorVariable.getValue(), (Matcher)CoreMatchers.is((Object)errorCode));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorProcess.bpmn", "org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorFromCallActivitySetsErrorVariables.bpmn"})
    public void testCatchErrorFromCallActivitySetsErrorVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorCode";
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assert.assertThat((Object)errorVariable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String errorCode = "error";
        Assert.assertThat((Object)errorVariable.getValue(), (Matcher)CoreMatchers.is((Object)errorCode));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchBpmnErrorFromJavaDelegateInsideCallActivitySetsErrorVariable.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithThrownError.bpmn"})
    public void testCatchBpmnErrorFromJavaDelegateInsideCallActivitySetsErrorVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        String variableName = "errorCode";
        String errorCode = "errorCode";
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assert.assertThat((Object)errorVariable.getValue(), (Matcher)CoreMatchers.is((Object)errorCode));
        errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("errorMessageVariable").singleResult();
        Assert.assertThat((Object)errorVariable.getValue(), (Matcher)CoreMatchers.is((Object)"ouch!"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoop.bpmn20.xml"})
    public void testShouldNotThrowErrorInLoop() {
        this.runtimeService.startProcessInstanceByKey("looping-error");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"WaitState", (String)task.getName());
        this.taskService.complete(task.getId());
        ErrorEventSubProcessTest.assertEquals((String)"ErrorHandlingUserTask", (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoopWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorToCallActivity.bpmn20.xml"})
    public void testShouldNotThrowErrorInLoopWithCallActivity() {
        this.runtimeService.startProcessInstanceByKey("CallActivityErrorInLoop");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"ErrorLog", (String)task.getName());
        this.taskService.complete(task.getId());
        ErrorEventSubProcessTest.assertEquals((String)"ErrorHandlingUserTask", (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoopWithMultipleSubProcess.bpmn20.xml"})
    public void testShouldNotThrowErrorInLoopForMultipleSubProcess() {
        this.runtimeService.startProcessInstanceByKey("looping-error");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"LoggerTask", (String)task.getName());
        this.taskService.complete(task.getId());
        ErrorEventSubProcessTest.assertEquals((String)"ErrorHandlingTask", (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoopFromCallActivityToEventSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorToCallActivity.bpmn20.xml"})
    public void FAILING_testShouldNotThrowErrorInLoopFromCallActivityToEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"userTask", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"ErrorLog", (String)task.getName());
        this.taskService.complete(task.getId());
        ErrorEventSubProcessTest.assertEquals((String)"BoundaryEventTask", (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment
    public void testThrownAnErrorInEventSubprocessInSubprocessDifferentTransaction() {
        this.runtimeService.startProcessInstanceByKey("eventSubProcess");
        Task taskBefore = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)taskBefore);
        ErrorEventSubProcessTest.assertEquals((String)"inside subprocess", (String)taskBefore.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        Task taskDuring = (Task)this.taskService.createTaskQuery().taskName("inside event sub").singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)taskDuring);
        this.taskService.complete(taskDuring.getId());
        Task taskAfter = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)taskAfter);
        ErrorEventSubProcessTest.assertEquals((String)"after catch", (String)taskAfter.getName());
        Job jobAfter = (Job)this.managementService.createJobQuery().singleResult();
        ErrorEventSubProcessTest.assertNull((Object)jobAfter);
    }

    @Deployment
    public void testThrownAnErrorInEventSubprocessInSubprocess() {
        this.runtimeService.startProcessInstanceByKey("eventSubProcess");
        Task taskBefore = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)taskBefore);
        ErrorEventSubProcessTest.assertEquals((String)"inside subprocess", (String)taskBefore.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        Task taskAfter = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertNotNull((Object)taskAfter);
        ErrorEventSubProcessTest.assertEquals((String)"after catch", (String)taskAfter.getName());
        Job jobAfter = (Job)this.managementService.createJobQuery().singleResult();
        ErrorEventSubProcessTest.assertNull((Object)jobAfter);
    }
}

