/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.cmmn10;

import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;

public class Cmmn10CompatibilityTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRequiredRule.cmmn"})
    public void testRequiredRule() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("required", (Object)true));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Cmmn10CompatibilityTest.assertNotNull((Object)taskExecution);
        Cmmn10CompatibilityTest.assertTrue((boolean)taskExecution.isRequired());
        try {
            this.caseService.completeCaseExecution(caseInstance.getId());
            Cmmn10CompatibilityTest.fail((String)"completing the containing stage should not be allowed");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testManualActivationRule.cmmn"})
    public void testManualActivationRule() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("manual", (Object)false));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Cmmn10CompatibilityTest.assertNotNull((Object)taskExecution);
        Cmmn10CompatibilityTest.assertTrue((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testManualActivationRuleWithoutCondition.cmmn"})
    public void testManualActivationRuleWithoutCondition() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("manual", (Object)false));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Cmmn10CompatibilityTest.assertNotNull((Object)taskExecution);
        Cmmn10CompatibilityTest.assertTrue((boolean)taskExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRepetitionRule.cmmn"})
    public void testRepetitionRule() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("repetition", (Object)true));
        String secondHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId();
        this.complete(secondHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        Cmmn10CompatibilityTest.assertEquals((long)2L, (long)query.count());
        Cmmn10CompatibilityTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRepetitionRuleWithoutEntryCriteria.cmmn"})
    public void testRepetitionRuleWithoutEntryCriteria() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("repetition", (Object)true));
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        Cmmn10CompatibilityTest.assertEquals((long)1L, (long)query.count());
        Cmmn10CompatibilityTest.assertEquals((long)1L, (long)query.active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRepetitionRuleCustomStandardEvent.cmmn"})
    public void testRepetitionRuleWithoutEntryCriteriaAndCustomStandardEvent() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("repetition", (Object)true));
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        Cmmn10CompatibilityTest.assertEquals((long)2L, (long)query.count());
        Cmmn10CompatibilityTest.assertEquals((long)1L, (long)query.enabled().count());
        Cmmn10CompatibilityTest.assertEquals((long)1L, (long)query.disabled().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testPlanItemEntryCriterion.cmmn"})
    public void testPlanItemEntryCriterion() {
        this.createCaseInstanceByKey("case");
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask);
        Cmmn10CompatibilityTest.assertTrue((boolean)this.queryCaseExecutionByActivityId("PI_HumanTask_2").isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testPlanItemExitCriterion.cmmn"})
    public void testPlanItemExitCriterion() {
        this.createCaseInstanceByKey("case");
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask);
        Cmmn10CompatibilityTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_HumanTask_2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testCasePlanModelExitCriterion.cmmn"})
    public void testCasePlanModelExitCriterion() {
        String caseInstanceId = this.createCaseInstanceByKey("case").getId();
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask);
        Cmmn10CompatibilityTest.assertTrue((boolean)this.queryCaseExecutionById(caseInstanceId).isTerminated());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testSentryIfPartCondition.cmmn"})
    public void testSentryIfPartCondition() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("value", (Object)99));
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        String humanTask2 = this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId();
        Cmmn10CompatibilityTest.assertTrue((boolean)this.queryCaseExecutionById(humanTask2).isAvailable());
        this.caseService.withCaseExecution(humanTask1).setVariable("value", (Object)999).manualStart();
        Cmmn10CompatibilityTest.assertTrue((boolean)this.queryCaseExecutionById(humanTask2).isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testDescription.cmmn"})
    public void testDescription() {
        this.createCaseInstanceByKey("case");
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Cmmn10CompatibilityTest.assertEquals((String)"This is a description!", (String)task.getDescription());
    }
}

