/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class HistoricProcessInstanceManagerProcessInstancesForCleanupTest {
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    protected static final String TWO_TASKS_PROCESS = "twoTasksProcess";
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    private HistoryService historyService;
    private RuntimeService runtimeService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Parameterized.Parameter(value=0)
    public int processDefiniotion1TTL;
    @Parameterized.Parameter(value=1)
    public int processDefiniotion2TTL;
    @Parameterized.Parameter(value=2)
    public int processInstancesOfProcess1Count;
    @Parameterized.Parameter(value=3)
    public int processInstancesOfProcess2Count;
    @Parameterized.Parameter(value=4)
    public int daysPassedAfterProcessEnd;
    @Parameterized.Parameter(value=5)
    public int batchSize;
    @Parameterized.Parameter(value=6)
    public int resultCount;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({3, 5, 3, 7, 4, 50, 3}, {3, 5, 3, 7, 2, 50, 0}, {3, 5, 3, 7, 6, 50, 10}, {3, 5, 3, 7, 6, 4, 4});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testFindHistoricProcessInstanceIdsForCleanup() {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.updateTimeToLive(commandContext, HistoricProcessInstanceManagerProcessInstancesForCleanupTest.ONE_TASK_PROCESS, HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.processDefiniotion1TTL);
                HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.updateTimeToLive(commandContext, HistoricProcessInstanceManagerProcessInstancesForCleanupTest.TWO_TASKS_PROCESS, HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.processDefiniotion2TTL);
                return null;
            }
        });
        List<String> ids = this.prepareHistoricProcesses(ONE_TASK_PROCESS, this.processInstancesOfProcess1Count);
        ids.addAll(this.prepareHistoricProcesses(TWO_TASKS_PROCESS, this.processInstancesOfProcess2Count));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)this.daysPassedAfterProcessEnd));
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                List historicProcessInstanceIdsForCleanup = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceIdsForCleanup(Integer.valueOf(HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.batchSize), 0, 60);
                Assert.assertEquals((long)HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.resultCount, (long)historicProcessInstanceIdsForCleanup.size());
                if (HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.resultCount > 0) {
                    List historicProcessInstances = HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(historicProcessInstanceIdsForCleanup)).list();
                    for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                        Assert.assertNotNull((Object)historicProcessInstance.getEndTime());
                        List processDefinitions = HistoricProcessInstanceManagerProcessInstancesForCleanupTest.this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(historicProcessInstance.getProcessDefinitionId()).list();
                        Assert.assertEquals((long)1L, (long)processDefinitions.size());
                        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)processDefinitions.get(0);
                        Assert.assertTrue((boolean)historicProcessInstance.getEndTime().before(DateUtils.addDays((Date)ClockUtil.getCurrentTime(), (int)processDefinition.getHistoryTimeToLive())));
                    }
                }
                return null;
            }
        });
    }

    private void updateTimeToLive(CommandContext commandContext, String businessKey, int timeToLive) {
        List processDefinitions = this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(businessKey).list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        ProcessDefinitionEntity processDefinition1 = (ProcessDefinitionEntity)processDefinitions.get(0);
        processDefinition1.setHistoryTimeToLive(Integer.valueOf(timeToLive));
        commandContext.getDbEntityManager().merge((DbEntity)processDefinition1);
    }

    private List<String> prepareHistoricProcesses(String businessKey, Integer processInstanceCount) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < processInstanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(businessKey);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }
}

