/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.authentication;

import ch.qos.logback.classic.Level;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LoginAttemptsTest {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String INDENTITY_LOGGER = "org.camunda.bpm.engine.identity";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJdbcUrl("jdbc:h2:mem:LoginAttemptsTest;DB_CLOSE_DELAY=1000");
            configuration.setDatabaseSchemaUpdate("create-drop");
            configuration.setLoginMaxAttempts(5);
            configuration.setLoginDelayFactor(2);
            configuration.setLoginDelayMaxTime(30);
            configuration.setLoginDelayBase(1);
            return configuration;
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.identity"}).level(Level.INFO);
    protected IdentityService identityService;
    protected ProcessEngine processEngine;

    @Before
    public void setup() {
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void tearDown() {
        ClockUtil.setCurrentTime((Date)new Date());
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
    }

    @Test
    public void testUsuccessfulAttemptsResultInLockedUser() throws ParseException {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        Date now = sdf.parse("2000-01-24T13:00:00");
        ClockUtil.setCurrentTime((Date)now);
        for (int i = 0; i <= 6; ++i) {
            Assertions.assertThat((boolean)this.identityService.checkPassword("johndoe", "invalid pwd")).isFalse();
            now = DateUtils.addSeconds((Date)now, (int)5);
            ClockUtil.setCurrentTime((Date)now);
        }
        Assertions.assertThat((int)this.loggingRule.getFilteredLog(INDENTITY_LOGGER, "The user with id 'johndoe' is permanently locked.").size()).isEqualTo(1);
    }
}

