/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.Objects;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SaveAuthorizationCmd
implements Command<Authorization> {
    protected AuthorizationEntity authorization;

    public SaveAuthorizationCmd(Authorization authorization) {
        this.authorization = (AuthorizationEntity)authorization;
        this.validate();
    }

    protected void validate() {
        EnsureUtil.ensureOnlyOneNotNull("Authorization must either have a 'userId' or a 'groupId'.", this.authorization.getUserId(), this.authorization.getGroupId());
        EnsureUtil.ensureNotNull("Authorization 'resourceType' cannot be null.", "authorization.getResource()", (Object)this.authorization.getResource());
    }

    @Override
    public Authorization execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.validateResourceCompatibility(this.authorization);
        if (this.isHistoricTaskInstanceResource()) {
            HistoryEvent historicTaskInstance = this.getHistoricTaskInstance(commandContext);
            this.provideRemovalTime(historicTaskInstance);
        }
        String operationType = null;
        AuthorizationEntity previousValues = null;
        if (this.authorization.getId() == null) {
            authorizationManager.insert(this.authorization);
            operationType = "Create";
        } else {
            previousValues = commandContext.getDbEntityManager().selectById(AuthorizationEntity.class, this.authorization.getId());
            authorizationManager.update(this.authorization);
            operationType = "Update";
        }
        commandContext.getOperationLogManager().logAuthorizationOperation(operationType, this.authorization, previousValues);
        return this.authorization;
    }

    protected void provideRemovalTime(HistoryEvent historicInstance) {
        if (historicInstance != null) {
            String rootProcessInstanceId = historicInstance.getRootProcessInstanceId();
            this.authorization.setRootProcessInstanceId(rootProcessInstanceId);
            Date removalTime = historicInstance.getRemovalTime();
            this.authorization.setRemovalTime(removalTime);
        } else {
            this.authorization.setRootProcessInstanceId(null);
            this.authorization.setRemovalTime(null);
        }
    }

    protected HistoryEvent getHistoricTaskInstance(CommandContext commandContext) {
        String historicTaskInstanceId = this.authorization.getResourceId();
        if (historicTaskInstanceId == null || this.isAny(historicTaskInstanceId)) {
            return null;
        }
        return commandContext.getHistoricTaskInstanceManager().findHistoricTaskInstanceById(historicTaskInstanceId);
    }

    protected boolean isAny(String historicTaskInstanceId) {
        return Objects.equals("*", historicTaskInstanceId);
    }

    protected boolean isHistoricTaskInstanceResource() {
        return Objects.equals(Resources.HISTORIC_TASK.resourceType(), this.authorization.getResource());
    }
}

