/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnExceptionHandler;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.ResourceTypes;

public class ExternalTaskEntity
implements ExternalTask,
DbEntity,
HasDbRevision,
HasDbReferences {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    private static final String EXCEPTION_NAME = "externalTask.exceptionByteArray";
    public static final int MAX_EXCEPTION_MESSAGE_LENGTH = 666;
    protected String id;
    protected int revision;
    protected String topicName;
    protected String workerId;
    protected Date lockExpirationTime;
    protected Integer retries;
    protected String errorMessage;
    protected ByteArrayEntity errorDetailsByteArray;
    protected String errorDetailsByteArrayId;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionVersionTag;
    protected String activityId;
    protected String activityInstanceId;
    protected String tenantId;
    protected long priority;
    protected ExecutionEntity execution;
    protected String businessKey;
    protected String lastFailureLogId;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topic) {
        this.topicName = topic;
    }

    @Override
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @Override
    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date lockExpirationTime) {
        this.lockExpirationTime = lockExpirationTime;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionVersionTag() {
        return this.processDefinitionVersionTag;
    }

    public void setProcessDefinitionVersionTag(String processDefinitionVersionTag) {
        this.processDefinitionVersionTag = processDefinitionVersionTag;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean areRetriesLeft() {
        return this.retries == null || this.retries > 0;
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("topic", this.topicName);
        persistentState.put("workerId", this.workerId);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        persistentState.put("retries", this.retries);
        persistentState.put("errorMessage", this.errorMessage);
        persistentState.put("executionId", this.executionId);
        persistentState.put("processInstanceId", this.processInstanceId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("processDefinitionKey", this.processDefinitionKey);
        persistentState.put("processDefinitionVersionTag", this.processDefinitionVersionTag);
        persistentState.put("activityId", this.activityId);
        persistentState.put("activityInstanceId", this.activityInstanceId);
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("tenantId", this.tenantId);
        persistentState.put("priority", this.priority);
        if (this.errorDetailsByteArrayId != null) {
            persistentState.put("errorDetailsByteArrayId", this.errorDetailsByteArrayId);
        }
        return persistentState;
    }

    public void insert() {
        Context.getCommandContext().getExternalTaskManager().insert(this);
        this.getExecution().addExternalTask(this);
    }

    public String getErrorDetails() {
        ByteArrayEntity byteArray = this.getErrorByteArray();
        return ExceptionUtil.getExceptionStacktrace(byteArray);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage != null && errorMessage.length() > 666 ? errorMessage.substring(0, 666) : errorMessage;
    }

    protected void setErrorDetails(String exception) {
        EnsureUtil.ensureNotNull("exception", (Object)exception);
        byte[] exceptionBytes = StringUtil.toByteArray(exception);
        ByteArrayEntity byteArray = this.getErrorByteArray();
        if (byteArray == null) {
            byteArray = ExceptionUtil.createExceptionByteArray(EXCEPTION_NAME, exceptionBytes, ResourceTypes.RUNTIME);
            this.errorDetailsByteArrayId = byteArray.getId();
            this.errorDetailsByteArray = byteArray;
        } else {
            byteArray.setBytes(exceptionBytes);
        }
    }

    public String getErrorDetailsByteArrayId() {
        return this.errorDetailsByteArrayId;
    }

    protected ByteArrayEntity getErrorByteArray() {
        this.ensureErrorByteArrayInitialized();
        return this.errorDetailsByteArray;
    }

    protected void ensureErrorByteArrayInitialized() {
        if (this.errorDetailsByteArray == null && this.errorDetailsByteArrayId != null) {
            this.errorDetailsByteArray = Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.errorDetailsByteArrayId);
        }
    }

    public void delete() {
        this.deleteFromExecutionAndRuntimeTable();
        this.produceHistoricExternalTaskDeletedEvent();
    }

    protected void deleteFromExecutionAndRuntimeTable() {
        this.getExecution().removeExternalTask(this);
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getExternalTaskManager().delete(this);
        if (this.errorDetailsByteArrayId != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(this.errorDetailsByteArrayId);
        }
    }

    public void complete(Map<String, Object> variables, Map<String, Object> localVariables) {
        this.ensureActive();
        ExecutionEntity associatedExecution = this.getExecution();
        if (variables != null) {
            associatedExecution.setVariables(variables);
        }
        if (localVariables != null) {
            associatedExecution.setVariablesLocal(localVariables);
        }
        this.deleteFromExecutionAndRuntimeTable();
        this.produceHistoricExternalTaskSuccessfulEvent();
        associatedExecution.signal(null, null);
    }

    public void failed(String errorMessage, String errorDetails, int retries, long retryDuration) {
        this.ensureActive();
        this.setErrorMessage(errorMessage);
        if (errorDetails != null) {
            this.setErrorDetails(errorDetails);
        }
        this.lockExpirationTime = new Date(ClockUtil.getCurrentTime().getTime() + retryDuration);
        this.produceHistoricExternalTaskFailedEvent();
        this.setRetriesAndManageIncidents(retries);
    }

    public void bpmnError(String errorCode, String errorMessage, Map<String, Object> variables) {
        this.ensureActive();
        ExecutionEntity activityExecution = this.getExecution();
        BpmnError bpmnError = null;
        bpmnError = errorMessage != null ? new BpmnError(errorCode, errorMessage) : new BpmnError(errorCode);
        try {
            if (variables != null && !variables.isEmpty()) {
                activityExecution.setVariables(variables);
            }
            BpmnExceptionHandler.propagateBpmnError(bpmnError, activityExecution);
        }
        catch (Exception ex) {
            throw ProcessEngineLogger.CMD_LOGGER.exceptionBpmnErrorPropagationFailed(errorCode, ex);
        }
    }

    public void setRetriesAndManageIncidents(int retries) {
        if (this.areRetriesLeft() && retries <= 0) {
            this.createIncident();
        } else if (!this.areRetriesLeft() && retries > 0) {
            this.removeIncident();
        }
        this.setRetries(retries);
    }

    protected void createIncident() {
        IncidentHandler incidentHandler = Context.getProcessEngineConfiguration().getIncidentHandler("failedExternalTask");
        IncidentContext incidentContext = this.createIncidentContext();
        incidentContext.setHistoryConfiguration(this.getLastFailureLogId());
        incidentHandler.handleIncident(incidentContext, this.errorMessage);
    }

    protected void removeIncident() {
        IncidentHandler handler = Context.getProcessEngineConfiguration().getIncidentHandler("failedExternalTask");
        handler.resolveIncident(this.createIncidentContext());
    }

    protected IncidentContext createIncidentContext() {
        IncidentContext context = new IncidentContext();
        context.setProcessDefinitionId(this.processDefinitionId);
        context.setExecutionId(this.executionId);
        context.setActivityId(this.activityId);
        context.setTenantId(this.tenantId);
        context.setConfiguration(this.id);
        return context;
    }

    public void lock(String workerId, long lockDuration) {
        this.workerId = workerId;
        this.lockExpirationTime = new Date(ClockUtil.getCurrentTime().getTime() + lockDuration);
    }

    public ExecutionEntity getExecution() {
        this.ensureExecutionInitialized();
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    protected void ensureExecutionInitialized() {
        if (this.execution == null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
            EnsureUtil.ensureNotNull("Cannot find execution with id " + this.executionId + " for external task " + this.id, "execution", (Object)this.execution);
        }
    }

    protected void ensureActive() {
        if (this.suspensionState == SuspensionState.SUSPENDED.getStateCode()) {
            throw LOG.suspendedEntityException("ExternalTask", this.id);
        }
    }

    public String toString() {
        return "ExternalTaskEntity [id=" + this.id + ", revision=" + this.revision + ", topicName=" + this.topicName + ", workerId=" + this.workerId + ", lockExpirationTime=" + this.lockExpirationTime + ", priority=" + this.priority + ", errorMessage=" + this.errorMessage + ", errorDetailsByteArray=" + this.errorDetailsByteArray + ", errorDetailsByteArrayId=" + this.errorDetailsByteArrayId + ", executionId=" + this.executionId + "]";
    }

    public void unlock() {
        this.workerId = null;
        this.lockExpirationTime = null;
        Context.getCommandContext().getExternalTaskManager().fireExternalTaskAvailableEvent();
    }

    public static ExternalTaskEntity createAndInsert(ExecutionEntity execution, String topic, long priority) {
        ExternalTaskEntity externalTask = new ExternalTaskEntity();
        externalTask.setTopicName(topic);
        externalTask.setExecutionId(execution.getId());
        externalTask.setProcessInstanceId(execution.getProcessInstanceId());
        externalTask.setProcessDefinitionId(execution.getProcessDefinitionId());
        externalTask.setActivityId(execution.getActivityId());
        externalTask.setActivityInstanceId(execution.getActivityInstanceId());
        externalTask.setTenantId(execution.getTenantId());
        externalTask.setPriority(priority);
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        externalTask.setProcessDefinitionKey(processDefinition.getKey());
        externalTask.insert();
        externalTask.produceHistoricExternalTaskCreatedEvent();
        return externalTask;
    }

    protected void produceHistoricExternalTaskCreatedEvent() {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricExternalTaskLogManager().fireExternalTaskCreatedEvent(this);
    }

    protected void produceHistoricExternalTaskFailedEvent() {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricExternalTaskLogManager().fireExternalTaskFailedEvent(this);
    }

    protected void produceHistoricExternalTaskSuccessfulEvent() {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricExternalTaskLogManager().fireExternalTaskSuccessfulEvent(this);
    }

    protected void produceHistoricExternalTaskDeletedEvent() {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricExternalTaskLogManager().fireExternalTaskDeletedEvent(this);
    }

    public void extendLock(long newLockExpirationTime) {
        this.ensureActive();
        long newTime = ClockUtil.getCurrentTime().getTime() + newLockExpirationTime;
        this.lockExpirationTime = new Date(newTime);
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referencedEntityIds = new HashSet<String>();
        return referencedEntityIds;
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        if (this.executionId != null) {
            referenceIdAndClass.put(this.executionId, ExecutionEntity.class);
        }
        if (this.errorDetailsByteArrayId != null) {
            referenceIdAndClass.put(this.errorDetailsByteArrayId, ByteArrayEntity.class);
        }
        return referenceIdAndClass;
    }

    public String getLastFailureLogId() {
        List logEntries;
        if (this.lastFailureLogId == null && !(logEntries = ((HistoricExternalTaskLogQuery)Context.getCommandContext().getProcessEngineConfiguration().getHistoryService().createHistoricExternalTaskLogQuery().failureLog().externalTaskId(this.id).orderByTimestamp().desc()).list()).isEmpty()) {
            this.lastFailureLogId = ((HistoricExternalTaskLog)logEntries.get(0)).getId();
        }
        return this.lastFailureLogId;
    }

    public void setLastFailureLogId(String lastFailureLogId) {
        this.lastFailureLogId = lastFailureLogId;
    }
}

