/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.DeploymentStatistics;
import org.camunda.bpm.engine.management.DeploymentStatisticsQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DisabledPermissionsAuthorizationTest {
    protected static final String USER_ID = "user";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    ProcessEngineConfigurationImpl processEngineConfiguration;
    RepositoryService repositoryService;
    AuthorizationService authorizationService;
    RuntimeService runtimeService;
    ManagementService managementService;
    TaskService taskService;

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup(USER_ID, "group");
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
    }

    @After
    public void tearDown() {
        this.authRule.disableAuthorization();
        this.authRule.deleteUsersAndGroups();
        this.processEngineConfiguration.setDisabledPermissions(null);
    }

    @Test
    public void testIsUserAuthorizedForIgnoredPermission() {
        this.processEngineConfiguration.setDisabledPermissions(Arrays.asList(Permissions.READ.name()));
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", USER_ID, new Permission[]{ProcessInstancePermissions.RETRY_JOB});
        this.authRule.enableAuthorization(USER_ID);
        this.exceptionRule.expect(BadUserRequestException.class);
        this.exceptionRule.expectMessage("The 'READ' permission is disabled, please check your process engine configuration.");
        this.authorizationService.isUserAuthorized(USER_ID, null, (Permission)Permissions.READ, (Resource)Resources.PROCESS_DEFINITION);
    }

    @Test
    public void testCustomPermissionDuplicateValue() {
        this.processEngineConfiguration.setDisabledPermissions(Arrays.asList(ProcessInstancePermissions.SUSPEND.name()));
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        Assert.assertEquals((long)ProcessInstancePermissions.SUSPEND.getValue(), (long)TestPermissions.RANDOM.getValue());
        this.authRule.createGrantAuthorization(resource1, "*", USER_ID, TestPermissions.RANDOM);
        this.authRule.createGrantAuthorization(resource2, "resource2-1", USER_ID, TestPermissions.RANDOM);
        this.authRule.enableAuthorization(USER_ID);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(USER_ID, null, (Permission)TestPermissions.RANDOM, (Resource)resource1));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(USER_ID, null, (Permission)TestPermissions.RANDOM, (Resource)resource2, "resource2-1"));
    }

    @Test
    public void testGetVariableIgnoreTaskRead() {
        this.processEngineConfiguration.setDisabledPermissions(Arrays.asList(TaskPermissions.READ.name()));
        String taskId = "taskId";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setVariables(taskId, (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        this.authRule.enableAuthorization(USER_ID);
        Object variable = this.taskService.getVariable(taskId, "foo");
        Assert.assertEquals((Object)"bar", (Object)variable);
        this.authRule.disableAuthorization();
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testQueryTaskIgnoreTaskRead() {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(TaskPermissions.READ.name());
        permissions.add(ProcessDefinitionPermissions.READ_TASK.name());
        this.processEngineConfiguration.setDisabledPermissions(permissions);
        String taskId = "taskId";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.authRule.enableAuthorization(USER_ID);
        Task returnedTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)returnedTask);
        this.authRule.disableAuthorization();
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteHistoricProcessInstanceIgnoreDeleteHistory() {
        this.processEngineConfiguration.setDisabledPermissions(Arrays.asList(Permissions.DELETE_HISTORY.name()));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "any");
        this.authRule.enableAuthorization(USER_ID);
        this.engineRule.getHistoryService().deleteHistoricProcessInstance(processInstance.getId());
        this.authRule.disableAuthorization();
        Assert.assertNull((Object)this.engineRule.getHistoryService().createHistoricProcessInstanceQuery().singleResult());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDeploymentIgnoreRead() {
        this.engineRule.getProcessEngineConfiguration().setDisabledPermissions(Arrays.asList(Permissions.READ.name()));
        this.authRule.enableAuthorization(USER_ID);
        List deployments = this.engineRule.getRepositoryService().createDeploymentQuery().list();
        Assert.assertEquals((long)1L, (long)deployments.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartableInTasklistIgnoreRead() {
        this.processEngineConfiguration.setDisabledPermissions(Arrays.asList(Permissions.READ.name()));
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneTaskProcess", USER_ID, new Permission[]{Permissions.CREATE_INSTANCE});
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", USER_ID, new Permission[]{Permissions.CREATE});
        this.authRule.disableAuthorization();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult();
        this.authRule.enableAuthorization(USER_ID);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().count());
        Assert.assertEquals((Object)definition.getId(), (Object)((ProcessDefinition)processDefinitions.get(0)).getId());
        Assert.assertTrue((boolean)((ProcessDefinition)processDefinitions.get(0)).isStartableInTasklist());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void testDeploymentStatisticsIgnoreReadInstance() {
        this.processEngineConfiguration.setDisabledPermissions(Arrays.asList(Permissions.READ_INSTANCE.name()));
        this.runtimeService.startProcessInstanceByKey("timerBoundaryProcess");
        this.authRule.enableAuthorization(USER_ID);
        DeploymentStatisticsQuery query = this.engineRule.getManagementService().createDeploymentStatisticsQuery();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            Assert.assertEquals((String)"Instances", (long)1L, (long)deploymentStatistics.getInstances());
            Assert.assertEquals((String)"Failed Jobs", (long)0L, (long)deploymentStatistics.getFailedJobs());
            List incidentStatistics = deploymentStatistics.getIncidentStatistics();
            Assert.assertTrue((String)"Incidents supposed to be empty", (boolean)incidentStatistics.isEmpty());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void testActivityStatisticsIgnoreRead() {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(Permissions.READ.name());
        permissions.add(Permissions.READ_INSTANCE.name());
        this.processEngineConfiguration.setDisabledPermissions(permissions);
        String processDefinitionId = this.runtimeService.startProcessInstanceByKey("timerBoundaryProcess").getProcessDefinitionId();
        this.authRule.enableAuthorization(USER_ID);
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"task", (Object)statistics.getId());
        Assert.assertEquals((long)1L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    @Ignore(value="CAM-9888")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchAndLockIgnoreRead() {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(Permissions.READ.name());
        permissions.add(Permissions.READ_INSTANCE.name());
        this.processEngineConfiguration.setDisabledPermissions(permissions);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", USER_ID, new Permission[]{Permissions.UPDATE});
        this.authRule.enableAuthorization(USER_ID);
        List externalTasks = this.engineRule.getExternalTaskService().fetchAndLock(1, "aWorkerId").topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        Assert.assertNotNull((Object)task.getId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)task.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)task.getProcessDefinitionId());
        Assert.assertEquals((Object)"externalTask", (Object)task.getActivityId());
        Assert.assertEquals((Object)"oneExternalTaskProcess", (Object)task.getProcessDefinitionKey());
    }

    protected void startProcessAndExecuteJob(String processDefinitionKey) {
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        this.executeAvailableJobs(processDefinitionKey);
    }

    protected void executeAvailableJobs(String key) {
        List jobs = this.managementService.createJobQuery().processDefinitionKey(key).withRetriesLeft().list();
        if (jobs.isEmpty()) {
            return;
        }
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
            }
            catch (Exception exception) {}
        }
        this.executeAvailableJobs(key);
    }
}

