/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.externaltask;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class GetTopicNamesAuthorizationTest
extends AuthorizationTest {
    protected String instance1Id;
    protected String instance2Id;

    @Override
    protected void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml").getId();
        this.instance1Id = this.startProcessInstanceByKey("oneExternalTaskProcess").getId();
        this.instance2Id = this.startProcessInstanceByKey("parallelExternalTaskProcess").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testGetTopicNamesWithoutAuthorization() {
        List result = this.externalTaskService.getTopicNames();
        GetTopicNamesAuthorizationTest.assertEquals((int)0, (int)result.size());
    }

    public void testGetTopicNamesWithReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List result = this.externalTaskService.getTopicNames();
        GetTopicNamesAuthorizationTest.assertEquals((int)1, (int)result.size());
        GetTopicNamesAuthorizationTest.assertEquals((String)"externalTaskTopic", (String)((String)result.get(0)));
    }

    public void testGetTopicNamesWithReadOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List result = this.externalTaskService.getTopicNames();
        GetTopicNamesAuthorizationTest.assertEquals((int)4, (int)result.size());
    }

    public void testGetTopicNamesWithReadInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List result = this.externalTaskService.getTopicNames();
        GetTopicNamesAuthorizationTest.assertEquals((int)4, (int)result.size());
    }

    public void testGetTopicNamesWithReadDefinitionWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List result = this.externalTaskService.getTopicNames();
        GetTopicNamesAuthorizationTest.assertEquals((int)1, (int)result.size());
        GetTopicNamesAuthorizationTest.assertEquals((String)"externalTaskTopic", (String)((String)result.get(0)));
    }

    public void testGetTopicNamesWithReadInstanceWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List result = this.externalTaskService.getTopicNames();
        GetTopicNamesAuthorizationTest.assertEquals((int)4, (int)result.size());
    }
}

