/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.UserOperationLogCategoryPermissions;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultPermissionProvider;
import org.camunda.bpm.engine.impl.cfg.auth.PermissionProvider;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;

@RequiredHistoryLevel(value="full")
public class AuthorizationUserOperationLogTest
extends AuthorizationTest {
    public void testLogCreatedOnAuthorizationCreation() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(ProcessDefinitionPermissions.DELETE.getValue()), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)ProcessDefinitionPermissions.DELETE.getName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(1), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"*", (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("groupId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"testGroupId", (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationUpdate() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Authorization authorization = this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", "testUserId", new Permission[]{Permissions.DELETE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("abc123");
        authorization.setGroupId("testGroupId");
        authorization.setUserId(null);
        this.saveAuthorization(authorization);
        AuthorizationUserOperationLogTest.assertEquals((long)7L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(Permissions.DELETE.getValue() | Permissions.READ.getValue()), (String)entry.getNewValue());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(Permissions.DELETE.getValue()), (String)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)(Permissions.READ.getName() + ", " + Permissions.DELETE.getName()), (String)entry.getNewValue());
        AuthorizationUserOperationLogTest.assertEquals((String)Permissions.DELETE.getName(), (String)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(1), (String)entry.getNewValue());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(1), (String)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)Resources.PROCESS_INSTANCE.resourceName(), (String)entry.getNewValue());
        AuthorizationUserOperationLogTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"abc123", (String)entry.getNewValue());
        AuthorizationUserOperationLogTest.assertEquals((String)"*", (String)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("userId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertNull((Object)entry.getNewValue());
        AuthorizationUserOperationLogTest.assertEquals((String)"testUserId", (String)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("groupId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"testGroupId", (String)entry.getNewValue());
        AuthorizationUserOperationLogTest.assertNull((Object)entry.getOrgValue());
    }

    public void testLogCreatedOnAuthorizationDeletion() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Authorization authorization = this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", "testUserId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.authorizationService.deleteAuthorization(authorization.getId());
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(ProcessDefinitionPermissions.DELETE.getValue()), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)ProcessDefinitionPermissions.DELETE.getName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(1), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"*", (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("userId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"testUserId", (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationCreationWithExceedingPermissionStringList() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.LONG_NAME);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)TestPermissions.LONG_NAME.getName().substring(0, StringUtil.DB_MAX_STRING_LENGTH), (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationCreationWithAllPermission() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.ALL);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)TestPermissions.ALL.getName(), (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationCreationWithNonePermission() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.NONE);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)TestPermissions.NONE.getName(), (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationCreationWithoutAuthorization() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
    }

    public void testLogCreatedOnAuthorizationCreationWithReadPermissionOnAnyCategoryPermission() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
    }

    public void testLogCreatedOnAuthorizationCreationWithReadPermissionOnWrongCategory() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Operator", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
    }

    public static class TestPermissionProvider
    extends DefaultPermissionProvider {
        public String getNameForResource(int resourceType) {
            for (TestResource resource : TestResource.values()) {
                if (resourceType != resource.resourceType()) continue;
                return resource.resourceName();
            }
            return null;
        }

        public Permission[] getPermissionsForResource(int resourceType) {
            return TestPermissions.values();
        }
    }
}

