/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import java.util.ArrayList;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationListener;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.camunda.bpm.dmn.feel.impl.FeelEngineFactory;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.dmn.el.ProcessEngineElProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DmnEngineConfigurationTest {
    protected static final String CONFIGURATION_XML = "org/camunda/bpm/engine/test/api/cfg/custom-dmn-camunda.cfg.xml";
    protected ProcessEngine engine;

    @After
    public void tearDown() {
        if (this.engine != null) {
            this.engine.close();
            this.engine = null;
        }
    }

    @Test
    public void setDefaultInputExpressionLanguage() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        dmnEngineConfiguration.setDefaultInputExpressionExpressionLanguage("groovy");
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertThat((Object)this.getConfigurationOfDmnEngine().getDefaultInputExpressionExpressionLanguage(), (Matcher)CoreMatchers.is((Object)"groovy"));
    }

    @Test
    public void setCustomPostTableExecutionListener() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        DmnDecisionTableEvaluationListener customEvaluationListener = (DmnDecisionTableEvaluationListener)Mockito.mock(DmnDecisionTableEvaluationListener.class);
        ArrayList<DmnDecisionTableEvaluationListener> customListeners = new ArrayList<DmnDecisionTableEvaluationListener>();
        customListeners.add(customEvaluationListener);
        dmnEngineConfiguration.setCustomPostDecisionTableEvaluationListeners(customListeners);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertThat((Object)this.getConfigurationOfDmnEngine().getCustomPostDecisionTableEvaluationListeners(), (Matcher)CoreMatchers.hasItem((Object)customEvaluationListener));
    }

    @Test
    public void setFeelEngineFactory() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        FeelEngineFactory feelEngineFactory = (FeelEngineFactory)Mockito.mock(FeelEngineFactory.class);
        dmnEngineConfiguration.setFeelEngineFactory(feelEngineFactory);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertThat((Object)this.getConfigurationOfDmnEngine().getFeelEngineFactory(), (Matcher)CoreMatchers.is((Object)feelEngineFactory));
    }

    @Test
    public void setScriptEngineResolver() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        DmnScriptEngineResolver scriptEngineResolver = (DmnScriptEngineResolver)Mockito.mock(DmnScriptEngineResolver.class);
        dmnEngineConfiguration.setScriptEngineResolver(scriptEngineResolver);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertThat((Object)this.getConfigurationOfDmnEngine().getScriptEngineResolver(), (Matcher)CoreMatchers.is((Object)scriptEngineResolver));
    }

    @Test
    public void setElProvider() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        ElProvider elProvider = (ElProvider)Mockito.mock(ElProvider.class);
        dmnEngineConfiguration.setElProvider(elProvider);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertThat((Object)this.getConfigurationOfDmnEngine().getElProvider(), (Matcher)CoreMatchers.is((Object)elProvider));
    }

    @Test
    public void setProcessEngineElProviderByDefault() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertEquals(ProcessEngineElProvider.class, this.getConfigurationOfDmnEngine().getElProvider().getClass());
    }

    @Test
    public void setProcessEngineScriptEnginesByDefault() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertEquals((Object)processEngineConfiguration.getScriptingEngines(), (Object)this.getConfigurationOfDmnEngine().getScriptEngineResolver());
    }

    @Test
    public void setDmnEngineConfigurationOverXmlConfiguration() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)CONFIGURATION_XML);
        DefaultDmnEngineConfiguration dmnEngineConfiguration = processEngineConfiguration.getDmnEngineConfiguration();
        Assert.assertThat((Object)dmnEngineConfiguration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dmnEngineConfiguration.getDefaultInputExpressionExpressionLanguage(), (Matcher)CoreMatchers.is((Object)"groovy"));
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertThat((Object)this.getConfigurationOfDmnEngine().getDefaultInputExpressionExpressionLanguage(), (Matcher)CoreMatchers.is((Object)"groovy"));
    }

    protected ProcessEngineConfigurationImpl createProcessEngineConfiguration() {
        return (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
    }

    protected DefaultDmnEngineConfiguration getConfigurationOfDmnEngine() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.engine.getProcessEngineConfiguration();
        DmnEngine dmnEngine = processEngineConfiguration.getDmnEngine();
        return (DefaultDmnEngineConfiguration)dmnEngine.getConfiguration();
    }
}

