/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SharedSqlSessionFactoryCfgTest {
    @Before
    @After
    public void cleanCachedSessionFactory() {
        ProcessEngineConfigurationImpl.cachedSqlSessionFactory = null;
    }

    @Test
    public void shouldNotReuseSqlSessionFactoryByDefault() {
        Assert.assertFalse((boolean)new StandaloneInMemProcessEngineConfiguration().isUseSharedSqlSessionFactory());
    }

    @Test
    public void shouldCacheDbSqlSessionFactoryIfConfigured() {
        TestEngineCfg cfg = new TestEngineCfg();
        cfg.setUseSharedSqlSessionFactory(true);
        cfg.initSqlSessionFactory();
        Assert.assertNotNull((Object)ProcessEngineConfigurationImpl.cachedSqlSessionFactory);
    }

    @Test
    public void shouldNotCacheDbSqlSessionFactoryIfNotConfigured() {
        TestEngineCfg cfg = new TestEngineCfg();
        cfg.initSqlSessionFactory();
        Assert.assertNull((Object)ProcessEngineConfigurationImpl.cachedSqlSessionFactory);
        Assert.assertNotNull((Object)cfg.getSqlSessionFactory());
    }

    @Test
    public void shouldReuseCachedSqlSessionFactoryIfConfigured() {
        SqlSessionFactory existingSessionFactory;
        TestEngineCfg cfg = new TestEngineCfg();
        ProcessEngineConfigurationImpl.cachedSqlSessionFactory = existingSessionFactory = (SqlSessionFactory)Mockito.mock(SqlSessionFactory.class);
        cfg.setUseSharedSqlSessionFactory(true);
        cfg.initSqlSessionFactory();
        Assert.assertSame((Object)existingSessionFactory, (Object)ProcessEngineConfigurationImpl.cachedSqlSessionFactory);
        Assert.assertSame((Object)existingSessionFactory, (Object)cfg.getSqlSessionFactory());
    }

    @Test
    public void shouldNotReuseCachedSqlSessionIfNotConfigured() {
        SqlSessionFactory existingSessionFactory;
        TestEngineCfg cfg = new TestEngineCfg();
        ProcessEngineConfigurationImpl.cachedSqlSessionFactory = existingSessionFactory = (SqlSessionFactory)Mockito.mock(SqlSessionFactory.class);
        cfg.initSqlSessionFactory();
        Assert.assertSame((Object)existingSessionFactory, (Object)ProcessEngineConfigurationImpl.cachedSqlSessionFactory);
        Assert.assertNotSame((Object)existingSessionFactory, (Object)cfg.getSqlSessionFactory());
    }

    static class TestEngineCfg
    extends StandaloneInMemProcessEngineConfiguration {
        public TestEngineCfg() {
            this.dataSource = (DataSource)Mockito.mock(DataSource.class);
            this.transactionFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        }

        public void initSqlSessionFactory() {
            super.initSqlSessionFactory();
        }

        public SqlSessionFactory getSqlSessionFactory() {
            return super.getSqlSessionFactory();
        }
    }
}

