/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.context;

import junit.framework.TestCase;
import org.camunda.bpm.engine.context.DelegateExecutionContext;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DelegateExecutionContextTest {
    protected static final BpmnModelInstance DELEGATION_PROCESS = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().serviceTask("serviceTask1").camundaClass(DelegateClass.class.getName())).endEvent().done();
    protected static final BpmnModelInstance EXEUCTION_LISTENER_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().camundaExecutionListenerClass("start", ExecutionListenerImpl.class.getName())).endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    public void testDelegateExecutionContext() {
        ProcessDefinition definition = this.testHelper.deployAndGetDefinition(DELEGATION_PROCESS);
        ProcessInstance instance = this.engineRule.getRuntimeService().startProcessInstanceById(definition.getId());
        DelegateExecution execution = DelegateExecutionContext.getCurrentDelegationExecution();
        TestCase.assertNull((Object)execution);
    }

    @Test
    public void testDelegateExecutionContextWithExecutionListener() {
        ProcessDefinition definition = this.testHelper.deployAndGetDefinition(EXEUCTION_LISTENER_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceById(definition.getId());
        DelegateExecution execution = DelegateExecutionContext.getCurrentDelegationExecution();
        TestCase.assertNull((Object)execution);
    }

    protected static void checkDelegationContext(DelegateExecution execution) {
        TestCase.assertNotNull((Object)DelegateExecutionContext.getCurrentDelegationExecution());
        TestCase.assertEquals((Object)DelegateExecutionContext.getCurrentDelegationExecution(), (Object)execution);
    }

    public static class DelegateClass
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            DelegateExecutionContextTest.checkDelegationContext(execution);
        }
    }

    public static class ExecutionListenerImpl
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            DelegateExecutionContextTest.checkDelegationContext(execution);
        }
    }
}

