/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BulkHistoryDeleteTest {
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    public static final int PROCESS_INSTANCE_COUNT = 5;
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    private HistoryService historyService;
    private TaskService taskService;
    private RuntimeService runtimeService;
    private FormService formService;
    private ExternalTaskService externalTaskService;
    private CaseService caseService;
    private IdentityService identityService;
    public static final String USER_ID = "demo";
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.formService = this.engineRule.getFormService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.caseService = this.engineRule.getCaseService();
        this.identityService = this.engineRule.getIdentityService();
        this.identityService.setAuthenticatedUserId(USER_ID);
    }

    @Before
    public void enableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void disableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryTaskIdentityLink() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        this.taskService.addUserIdentityLink(((Task)taskList.get(0)).getId(), "someUser", "assignee");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricIdentityLinkLogQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryActivityInstances() {
        List<String> ids = this.prepareHistoricProcesses();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupTaskAttachmentWithContent() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        String taskWithAttachmentId = ((Task)taskList.get(0)).getId();
        this.createTaskAttachmentWithContent(taskWithAttachmentId);
        String contentId = this.findAttachmentContentId(this.taskService.getTaskAttachments(taskWithAttachmentId));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getTaskAttachments(taskWithAttachmentId).size());
        this.verifyByteArraysWereRemoved(contentId);
    }

    private String findAttachmentContentId(List<Attachment> attachments) {
        Assert.assertEquals((long)1L, (long)attachments.size());
        return ((AttachmentEntity)attachments.get(0)).getContentId();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupProcessInstanceAttachmentWithContent() {
        List<String> ids = this.prepareHistoricProcesses();
        String processInstanceWithAttachmentId = ids.get(0);
        this.createProcessInstanceAttachmentWithContent(processInstanceWithAttachmentId);
        String contentId = this.findAttachmentContentId(this.taskService.getProcessInstanceAttachments(processInstanceWithAttachmentId));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getProcessInstanceAttachments(processInstanceWithAttachmentId).size());
        this.verifyByteArraysWereRemoved(contentId);
    }

    private void createProcessInstanceAttachmentWithContent(String processInstanceId) {
        this.taskService.createAttachment("web page", null, processInstanceId, "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
        List taskAttachments = this.taskService.getProcessInstanceAttachments(processInstanceId);
        Assert.assertEquals((long)1L, (long)taskAttachments.size());
        Assert.assertNotNull((Object)this.taskService.getAttachmentContent(((Attachment)taskAttachments.get(0)).getId()));
    }

    private void createTaskAttachmentWithContent(String taskId) {
        this.taskService.createAttachment("web page", taskId, null, "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
        List taskAttachments = this.taskService.getTaskAttachments(taskId);
        Assert.assertEquals((long)1L, (long)taskAttachments.size());
        Assert.assertNotNull((Object)this.taskService.getAttachmentContent(((Attachment)taskAttachments.get(0)).getId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupTaskComment() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        String taskWithCommentId = ((Task)taskList.get(2)).getId();
        this.taskService.createComment(taskWithCommentId, null, "Some comment");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getTaskComments(taskWithCommentId).size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupProcessInstanceComment() {
        List<String> ids = this.prepareHistoricProcesses();
        String processInstanceWithCommentId = ids.get(0);
        this.taskService.createComment(null, processInstanceWithCommentId, "Some comment");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getProcessInstanceComments(processInstanceWithCommentId).size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoricVariableInstancesAndHistoricDetails() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        this.taskService.setVariables(((Task)taskList.get(0)).getId(), (Map)this.getVariables());
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryTaskForm() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        this.formService.submitTaskForm(((Task)taskList.get(0)).getId(), (Map)this.getVariables());
        for (ProcessInstance processInstance : this.runtimeService.createProcessInstanceQuery().list()) {
            this.runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), null);
        }
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCleanupHistoricExternalTaskLog() {
        List<String> ids = this.prepareHistoricProcesses("oneExternalTaskProcess");
        String workerId = "aWrokerId";
        List tasks = this.externalTaskService.fetchAndLock(1, workerId).topic("externalTaskTopic", 10000L).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)tasks.get(0)).getId(), workerId, "errorMessage", "exceptionStackTrace", 5, 3000L);
        String errorDetailsByteArrayId = this.findErrorDetailsByteArrayId("errorMessage");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricExternalTaskLogQuery().count());
        this.verifyByteArraysWereRemoved(errorDetailsByteArrayId);
    }

    private String findErrorDetailsByteArrayId(String errorMessage) {
        List historicExternalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().errorMessage(errorMessage).list();
        Assert.assertEquals((long)1L, (long)historicExternalTaskLogs.size());
        return ((HistoricExternalTaskLogEntity)historicExternalTaskLogs.get(0)).getErrorDetailsByteArrayId();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testCleanupHistoricIncidents() {
        List<String> ids = this.prepareHistoricProcesses("failingProcess");
        this.testRule.executeAvailableJobs();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("failingProcess").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricIncidentQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testCleanupHistoricJobLogs() {
        List<String> ids = this.prepareHistoricProcesses("failingProcess", null, 1);
        this.testRule.executeAvailableJobs();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        List<String> byteArrayIds = this.findExceptionByteArrayIds();
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("failingProcess").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().count());
        this.verifyByteArraysWereRemoved(byteArrayIds.toArray(new String[0]));
    }

    private List<String> findExceptionByteArrayIds() {
        ArrayList<String> exceptionByteArrayIds = new ArrayList<String>();
        List historicJobLogs = this.historyService.createHistoricJobLogQuery().list();
        for (HistoricJobLog historicJobLog : historicJobLogs) {
            HistoricJobLogEventEntity historicJobLogEventEntity = (HistoricJobLogEventEntity)historicJobLog;
            if (historicJobLogEventEntity.getExceptionByteArrayId() == null) continue;
            exceptionByteArrayIds.add(historicJobLogEventEntity.getExceptionByteArrayId());
        }
        return exceptionByteArrayIds;
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void testCleanupHistoryDecisionData() {
        List<String> ids = this.prepareHistoricProcesses("testProcess", Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs().list();
        ArrayList<String> inputIds = new ArrayList<String>();
        ArrayList<String> inputByteArrayIds = new ArrayList<String>();
        this.collectHistoricDecisionInputIds(historicDecisionInstances, inputIds, inputByteArrayIds);
        ArrayList<String> outputIds = new ArrayList<String>();
        ArrayList<String> outputByteArrayIds = new ArrayList<String>();
        this.collectHistoricDecisionOutputIds(historicDecisionInstances, outputIds, outputByteArrayIds);
        this.historyService.deleteHistoricDecisionInstancesBulk(this.extractIds(historicDecisionInstances));
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        this.assertDataDeleted(inputIds, inputByteArrayIds, outputIds, outputByteArrayIds);
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").property("nrOfInstances").list();
        Assert.assertEquals((long)1L, (long)userOperationLogEntries.size());
        UserOperationLogEntry entry = (UserOperationLogEntry)userOperationLogEntries.get(0);
        Assert.assertEquals((Object)String.valueOf(historicDecisionInstances.size()), (Object)entry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void testCleanupFakeHistoryDecisionData() {
        List<String> ids = Arrays.asList("aFake");
        this.historyService.deleteHistoricDecisionInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
    }

    void assertDataDeleted(final List<String> inputIds, final List<String> inputByteArrayIds, final List<String> outputIds, final List<String> outputByteArrayIds) {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (String inputId : inputIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectById(HistoricDecisionInputInstanceEntity.class, inputId));
                }
                for (String inputByteArrayId : inputByteArrayIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, inputByteArrayId));
                }
                for (String outputId : outputIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectById(HistoricDecisionOutputInstanceEntity.class, outputId));
                }
                for (String outputByteArrayId : outputByteArrayIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, outputByteArrayId));
                }
                return null;
            }
        });
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void testCleanupHistoryStandaloneDecisionData() {
        for (int i = 0; i < 5; ++i) {
            this.engineRule.getDecisionService().evaluateDecisionByKey("testDecision").variables((Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37))).evaluate();
        }
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs().list();
        ArrayList<String> inputIds = new ArrayList<String>();
        ArrayList<String> inputByteArrayIds = new ArrayList<String>();
        this.collectHistoricDecisionInputIds(historicDecisionInstances, inputIds, inputByteArrayIds);
        ArrayList<String> outputIds = new ArrayList<String>();
        ArrayList<String> outputByteArrayIds = new ArrayList<String>();
        this.collectHistoricDecisionOutputIds(historicDecisionInstances, outputIds, outputByteArrayIds);
        List<String> decisionInstanceIds = this.extractIds(historicDecisionInstances);
        this.historyService.deleteHistoricDecisionInstancesBulk(decisionInstanceIds);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("testProcess").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        this.assertDataDeleted(inputIds, inputByteArrayIds, outputIds, outputByteArrayIds);
    }

    private List<String> extractIds(List<HistoricDecisionInstance> historicDecisionInstances) {
        ArrayList<String> decisionInstanceIds = new ArrayList<String>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            decisionInstanceIds.add(historicDecisionInstance.getId());
        }
        return decisionInstanceIds;
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryEmptyProcessIdsException() {
        List<String> ids = this.prepareHistoricProcesses();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        try {
            this.historyService.deleteHistoricProcessInstancesBulk(null);
            Assert.fail((String)"Empty process instance ids exception was expected");
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
        try {
            this.historyService.deleteHistoricProcessInstancesBulk(new ArrayList());
            Assert.fail((String)"Empty process instance ids exception was expected");
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryProcessesNotFinishedException() {
        List<String> ids = this.prepareHistoricProcesses();
        this.runtimeService.deleteProcessInstances(ids.subList(1, ids.size()), null, true, true);
        try {
            this.historyService.deleteHistoricProcessInstancesBulk(ids);
            Assert.fail((String)"Not all processes are finished exception was expected");
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
    }

    private void collectHistoricDecisionInputIds(List<HistoricDecisionInstance> historicDecisionInstances, List<String> historicDecisionInputIds, List<String> inputByteArrayIds) {
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            for (HistoricDecisionInputInstance inputInstanceEntity : historicDecisionInstance.getInputs()) {
                historicDecisionInputIds.add(inputInstanceEntity.getId());
                String byteArrayValueId = ((HistoricDecisionInputInstanceEntity)inputInstanceEntity).getByteArrayValueId();
                if (byteArrayValueId == null) continue;
                inputByteArrayIds.add(byteArrayValueId);
            }
        }
        Assert.assertEquals((long)5L, (long)historicDecisionInputIds.size());
    }

    private void collectHistoricDecisionOutputIds(List<HistoricDecisionInstance> historicDecisionInstances, List<String> historicDecisionOutputIds, List<String> outputByteArrayId) {
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            for (HistoricDecisionOutputInstance outputInstanceEntity : historicDecisionInstance.getOutputs()) {
                historicDecisionOutputIds.add(outputInstanceEntity.getId());
                String byteArrayValueId = ((HistoricDecisionOutputInstanceEntity)outputInstanceEntity).getByteArrayValueId();
                if (byteArrayValueId == null) continue;
                outputByteArrayId.add(byteArrayValueId);
            }
        }
        Assert.assertEquals((long)5L, (long)historicDecisionOutputIds.size());
    }

    private List<String> prepareHistoricProcesses() {
        return this.prepareHistoricProcesses(ONE_TASK_PROCESS);
    }

    private List<String> prepareHistoricProcesses(String businessKey) {
        return this.prepareHistoricProcesses(businessKey, null);
    }

    private List<String> prepareHistoricProcesses(String businessKey, VariableMap variables) {
        return this.prepareHistoricProcesses(businessKey, variables, 5);
    }

    private List<String> prepareHistoricProcesses(String businessKey, VariableMap variables, Integer processInstanceCount) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < processInstanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(businessKey, (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }

    private void verifyByteArraysWereRemoved(final String ... errorDetailsByteArrayIds) {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (String errorDetailsByteArrayId : errorDetailsByteArrayIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectOne("selectByteArray", (Object)errorDetailsByteArrayId));
                }
                return null;
            }
        });
    }

    private VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue").putValue("pojoVariableName", (Object)new TestPojo("someValue", 111.0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstance() {
        int instanceCount = 10;
        List<String> caseInstanceIds = this.prepareHistoricCaseInstance(instanceCount);
        List caseInstanceList = this.historyService.createHistoricCaseInstanceQuery().list();
        Assert.assertEquals((long)instanceCount, (long)caseInstanceList.size());
        this.historyService.deleteHistoricCaseInstancesBulk(caseInstanceIds);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseActivityInstance() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.terminateAndCloseCaseInstance(caseInstanceId, null);
        List activityInstances = this.historyService.createHistoricCaseActivityInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)activityInstances.size());
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstanceId));
        activityInstances = this.historyService.createHistoricCaseActivityInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)activityInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceTask() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.terminateAndCloseCaseInstance(caseInstanceId, null);
        List taskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)taskInstances.size());
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstanceId));
        taskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)taskInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceTaskComment() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.createComment(task.getId(), null, "This is a comment...");
        List comments = this.taskService.getTaskComments(task.getId());
        Assert.assertEquals((long)1L, (long)comments.size());
        this.terminateAndCloseCaseInstance(caseInstanceId, null);
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstanceId));
        comments = this.taskService.getTaskComments(task.getId());
        Assert.assertEquals((long)0L, (long)comments.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceTaskDetails() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(task.getId(), "boo", (Object)new TestPojo("foo", 123.0));
        this.taskService.setVariable(task.getId(), "goo", (Object)9);
        this.taskService.setVariable(task.getId(), "boo", (Object)new TestPojo("foo", 321.0));
        List detailsList = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)3L, (long)detailsList.size());
        this.terminateAndCloseCaseInstance(caseInstance.getId(), this.taskService.getVariables(task.getId()));
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstance.getId()));
        detailsList = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)detailsList.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceTaskIdentityLink() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.addGroupIdentityLink(task.getId(), "accounting", "candidate");
        int identityLinksForTask = this.taskService.getIdentityLinksForTask(task.getId()).size();
        Assert.assertEquals((long)1L, (long)identityLinksForTask);
        this.terminateAndCloseCaseInstance(caseInstanceId, null);
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstanceId));
        List historicIdentityLinkLog = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)0L, (long)historicIdentityLinkLog.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceTaskAttachmentByteArray() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String taskId = task.getId();
        this.taskService.createAttachment("foo", taskId, null, "something", null, (InputStream)new ByteArrayInputStream("someContent".getBytes()));
        List attachments = this.taskService.getTaskAttachments(taskId);
        Assert.assertEquals((long)1L, (long)attachments.size());
        String contentId = this.findAttachmentContentId(attachments);
        this.terminateAndCloseCaseInstance(caseInstance.getId(), null);
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstance.getId()));
        attachments = this.taskService.getTaskAttachments(taskId);
        Assert.assertEquals((long)0L, (long)attachments.size());
        this.verifyByteArraysWereRemoved(contentId);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceTaskAttachmentUrl() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.createAttachment("foo", task.getId(), null, "something", null, "http://camunda.org");
        List attachments = this.taskService.getTaskAttachments(task.getId());
        Assert.assertEquals((long)1L, (long)attachments.size());
        this.terminateAndCloseCaseInstance(caseInstanceId, null);
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstanceId));
        attachments = this.taskService.getTaskAttachments(task.getId());
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceVariables() {
        ArrayList<String> caseInstanceIds = new ArrayList<String>();
        int instanceCount = 10;
        for (int i = 0; i < instanceCount; ++i) {
            VariableMap variables = Variables.createVariables();
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)variables.putValue("name" + i, (Object)"theValue"));
            caseInstanceIds.add(caseInstance.getId());
            this.terminateAndCloseCaseInstance(caseInstance.getId(), (Map<String, Object>)variables);
        }
        List variablesInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)instanceCount, (long)variablesInstances.size());
        this.historyService.deleteHistoricCaseInstancesBulk(caseInstanceIds);
        variablesInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variablesInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceComplexVariable() {
        VariableMap variables = Variables.createVariables();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)variables.putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        this.caseService.setVariable(caseInstance.getId(), "pojo", (Object)"theValue");
        List variablesInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)variablesInstances.size());
        List detailsList = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)2L, (long)detailsList.size());
        this.terminateAndCloseCaseInstance(caseInstance.getId(), (Map<String, Object>)variables);
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstance.getId()));
        variablesInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variablesInstances.size());
        detailsList = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)detailsList.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceDetails() {
        String variableNameCase1 = "varName1";
        CaseInstance caseInstance1 = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.createVariables().putValue(variableNameCase1, (Object)"value1"));
        CaseInstance caseInstance2 = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.createVariables().putValue("varName2", (Object)"value2"));
        this.caseService.setVariable(caseInstance1.getId(), variableNameCase1, (Object)"theValue");
        List detailsList = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)3L, (long)detailsList.size());
        this.caseService.terminateCaseExecution(caseInstance1.getId(), this.caseService.getVariables(caseInstance1.getId()));
        this.caseService.terminateCaseExecution(caseInstance2.getId(), this.caseService.getVariables(caseInstance2.getId()));
        this.caseService.closeCaseInstance(caseInstance1.getId());
        this.caseService.closeCaseInstance(caseInstance2.getId());
        this.historyService.deleteHistoricCaseInstancesBulk(Arrays.asList(caseInstance1.getId(), caseInstance2.getId()));
        detailsList = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)detailsList.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCleanupHistoryCaseInstanceOperationLog() {
        int instanceCount = 10;
        List<String> caseInstanceIds = this.prepareHistoricCaseInstance(instanceCount);
        List caseInstanceList = this.historyService.createHistoricCaseInstanceQuery().list();
        Assert.assertEquals((long)instanceCount, (long)caseInstanceList.size());
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.historyService.deleteHistoricCaseInstancesBulk(caseInstanceIds);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").count());
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").singleResult();
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
        Assert.assertEquals((Object)"CaseInstance", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"DeleteHistory", (Object)entry.getOperationType());
        Assert.assertNull((Object)entry.getCaseInstanceId());
        Assert.assertEquals((Object)"nrOfInstances", (Object)entry.getProperty());
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertEquals((Object)String.valueOf(instanceCount), (Object)entry.getNewValue());
    }

    private List<String> prepareHistoricCaseInstance(int instanceCount) {
        ArrayList<String> caseInstanceIds = new ArrayList<String>();
        for (int i = 0; i < instanceCount; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
            String caseInstanceId = caseInstance.getId();
            caseInstanceIds.add(caseInstanceId);
            this.terminateAndCloseCaseInstance(caseInstanceId, null);
        }
        return caseInstanceIds;
    }

    private void terminateAndCloseCaseInstance(String caseInstanceId, Map<String, Object> variables) {
        if (variables == null) {
            this.caseService.terminateCaseExecution(caseInstanceId, variables);
        } else {
            this.caseService.terminateCaseExecution(caseInstanceId);
        }
        this.caseService.closeCaseInstance(caseInstanceId);
    }
}

