/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.HistoricTaskPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class EnableHistoricInstancePermissionsTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.thrown);
    protected ProcessEngineConfigurationImpl config;
    protected AuthorizationService authorizationService;

    @Before
    public void assign() {
        this.config = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void resetConfig() {
        this.config.setEnableHistoricInstancePermissions(false);
    }

    @Test
    public void shouldBeFalseByDefault() {
        Assertions.assertThat((boolean)this.config.isEnableHistoricInstancePermissions()).isFalse();
    }

    @Test
    public void shouldBeConfiguredToTrue() {
        this.config.setEnableHistoricInstancePermissions(true);
        Assertions.assertThat((boolean)this.config.isEnableHistoricInstancePermissions()).isTrue();
    }

    @Test
    public void shouldBeConfiguredToFalse() {
        this.config.setEnableHistoricInstancePermissions(false);
        Assertions.assertThat((boolean)this.config.isEnableHistoricInstancePermissions()).isFalse();
    }

    @Test
    public void shouldThrowExceptionWhenHistoricInstancePermissionsAreDisabled_Task() {
        this.config.setEnableHistoricInstancePermissions(false);
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("ENGINE-03090 Historic instance permissions are disabled, please check your process engine configuration.");
        this.authorizationService.isUserAuthorized("myUserId", null, (Permission)HistoricTaskPermissions.ALL, (Resource)Resources.HISTORIC_TASK);
    }

    @Test
    public void shouldThrowExceptionWhenHistoricInstancePermissionsAreDisabled_ProcessInstance() {
        this.config.setEnableHistoricInstancePermissions(false);
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("ENGINE-03090 Historic instance permissions are disabled, please check your process engine configuration.");
        this.authorizationService.isUserAuthorized("myUserId", null, (Permission)HistoricTaskPermissions.ALL, (Resource)Resources.HISTORIC_PROCESS_INSTANCE);
    }
}

