/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyTaskQueryTest
extends PluggableProcessEngineTestCase {
    private static final String TENANT_ONE = "tenant1";
    private static final String TENANT_TWO = "tenant2";
    private static final String TENANT_NON_EXISTING = "nonExistingTenant";
    private final List<String> taskIds = new ArrayList<String>();

    protected void setUp() throws Exception {
        this.createTaskWithoutTenant();
        this.createTaskForTenant(TENANT_ONE);
        this.createTaskForTenant(TENANT_TWO);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryByTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByTenantIds() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_NON_EXISTING});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByTasksWithoutTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_NON_EXISTING});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testQueryByTenantIdNullFails() {
        try {
            MultiTenancyTaskQueryTest.assertEquals((Object)0, (Object)this.taskService.createTaskQuery().tenantIdIn(new String[]{null}));
            MultiTenancyTaskQueryTest.fail((String)"Exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected String createTaskWithoutTenant() {
        return this.createTaskForTenant(null);
    }

    protected String createTaskForTenant(String tenantId) {
        Task task = this.taskService.newTask();
        if (tenantId != null) {
            task.setTenantId(tenantId);
        }
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskIds.add(taskId);
        return taskId;
    }

    protected void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        for (String taskId : this.taskIds) {
            this.taskService.deleteTask(taskId, true);
        }
        this.taskIds.clear();
    }
}

