/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetHistoricVariableUpdatesForOptimizeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected String userId = "test";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.createUser(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void getHistoricVariableUpdates() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "foo");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(1L), null, 10);
        Assertions.assertThat((int)historicVariableUpdates.size()).isEqualTo(1);
        this.assertThatUpdateHasAllImportantInformation((HistoricVariableUpdate)historicVariableUpdates.get(0));
    }

    @Test
    public void occurredAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "value1");
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(new Date().getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.put("stringVar", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(now, null, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(1);
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(0)).getValue().toString()).isEqualTo((Object)"value2");
    }

    @Test
    public void occurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.put("stringVar", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(null, now, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(1);
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(0)).getValue().toString()).isEqualTo((Object)"value1");
    }

    @Test
    public void occurredAfterAndOccurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.put("stringVar", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(now, now, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(0);
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "value1");
        variables.put("integerVar", 1);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(this.pastDate(), null, 3);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(3);
    }

    @Test
    public void resultIsSortedByTime() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus1Second = new Date(now.getTime() + 1000L);
        ClockUtil.setCurrentTime((Date)nowPlus1Second);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.clear();
        variables.put("var2", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus4Seconds = new Date(nowPlus2Seconds.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        variables.clear();
        variables.put("var3", "value3");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(now, null, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(3);
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(0)).getVariableName()).isEqualTo((Object)"var1");
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(1)).getVariableName()).isEqualTo((Object)"var2");
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(2)).getVariableName()).isEqualTo((Object)"var3");
    }

    @Test
    public void fetchOnlyVariableUpdates() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> formFields = new HashMap<String, String>();
        formFields.put("var", "foo");
        this.engineRule.getFormService().submitTaskFormData(task.getId(), formFields);
        long detailCount = this.engineRule.getHistoryService().createHistoricDetailQuery().count();
        Assertions.assertThat((long)detailCount).isEqualTo(2L);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(this.pastDate(), null, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(1);
    }

    @Test
    public void getHistoricVariableByteArrayUpdates() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        HashMap<String, ArrayList<String>> variables = new HashMap<String, ArrayList<String>>();
        variables.put("var", serializable);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(1L), null, 10);
        Assertions.assertThat((int)historicVariableUpdates.size()).isEqualTo(4);
        for (HistoricVariableUpdate variableUpdate : historicVariableUpdates) {
            ObjectValue typedValue = (ObjectValue)variableUpdate.getTypedValue();
            Assertions.assertThat((boolean)typedValue.isDeserialized()).isFalse();
            Assertions.assertThat((String)typedValue.getValueSerialized()).isNotNull();
        }
    }

    @Test
    @RequiredDatabase(excludes={"h2"})
    public void testFetchLargeNumberOfObjectVariables() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("waitState").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        int numberOfVariables = 3000;
        VariableMap variables = this.createVariables(numberOfVariables);
        this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(1L), null, 10000);
        Assertions.assertThat((List)historicVariableUpdates).hasSize(numberOfVariables);
        for (HistoricVariableUpdate update : historicVariableUpdates) {
            ObjectValue typedValue = (ObjectValue)update.getTypedValue();
            Assertions.assertThat((String)typedValue.getValueSerialized()).isNotNull();
        }
    }

    private VariableMap createVariables(int num) {
        VariableMap variables = Variables.createVariables();
        for (int i = 0; i < num; ++i) {
            variables.put((Object)("var" + i), (Object)Variables.objectValue((Object)i));
        }
        return variables;
    }

    private Date pastDate() {
        return new Date(2L);
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatUpdateHasAllImportantInformation(HistoricVariableUpdate variableUpdate) {
        Assertions.assertThat((Object)variableUpdate).isNotNull();
        Assertions.assertThat((String)variableUpdate.getId()).isNotNull();
        Assertions.assertThat((String)variableUpdate.getProcessDefinitionKey()).isEqualTo((Object)"process");
        Assertions.assertThat((String)variableUpdate.getProcessDefinitionId()).isNotNull();
        Assertions.assertThat((String)variableUpdate.getVariableName()).isEqualTo((Object)"stringVar");
        Assertions.assertThat((String)variableUpdate.getValue().toString()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)variableUpdate.getTypeName()).isEqualTo((Object)"string");
        Assertions.assertThat((Date)variableUpdate.getTime()).isNotNull();
    }
}

