/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationBoundaryEventsTest {
    public static final String AFTER_BOUNDARY_TASK = "afterBoundary";
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    protected static final String FALSE_CONDITION = "${false}";
    protected static final String VAR_CONDITION = "${any=='any'}";
    protected static final String BOUNDARY_ID = "boundary";
    protected static final String USER_TASK_ID = "userTask";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateMultipleBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("timerBoundary1").timerWithDate(TIMER_DATE)).moveToActivity("subProcess").boundaryEvent("messageBoundary1").message(MESSAGE_NAME)).moveToActivity("subProcess").boundaryEvent("signalBoundary1").signal(SIGNAL_NAME)).moveToActivity("subProcess").boundaryEvent("conditionalBoundary1").condition(VAR_CONDITION)).moveToActivity(USER_TASK_ID).boundaryEvent("timerBoundary2").timerWithDate(TIMER_DATE)).moveToActivity(USER_TASK_ID).boundaryEvent("messageBoundary2").message(MESSAGE_NAME)).moveToActivity(USER_TASK_ID).boundaryEvent("signalBoundary2").signal(SIGNAL_NAME)).moveToActivity(USER_TASK_ID).boundaryEvent("conditionalBoundary2").condition(VAR_CONDITION)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("timerBoundary1", "timerBoundary1").mapActivities("signalBoundary1", "signalBoundary1").mapActivities("conditionalBoundary1", "conditionalBoundary1").updateEventTrigger().mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities("messageBoundary2", "messageBoundary2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("messageBoundary1", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionRemoved("signalBoundary2", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionRemoved("conditionalBoundary2", null);
        this.testHelper.assertEventSubscriptionMigrated("signalBoundary1", "signalBoundary1", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionMigrated("messageBoundary2", "messageBoundary2", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionMigrated("conditionalBoundary1", "conditionalBoundary1", null);
        this.testHelper.assertEventSubscriptionCreated("messageBoundary1", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionCreated("signalBoundary2", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionCreated("conditionalBoundary2", null);
        this.testHelper.assertBoundaryTimerJobRemoved("timerBoundary2");
        this.testHelper.assertBoundaryTimerJobMigrated("timerBoundary1", "timerBoundary1");
        this.testHelper.assertBoundaryTimerJobCreated("timerBoundary2");
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventAndEventSubProcess() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").message(MESSAGE_NAME)).endEvent().subProcessDone().moveToActivity(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).signal(SIGNAL_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(BOUNDARY_ID, BOUNDARY_ID).mapActivities(USER_TASK_ID, USER_TASK_ID).build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("eventStart", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionMigrated(BOUNDARY_ID, BOUNDARY_ID, SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionCreated("eventStart", MESSAGE_NAME);
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateIncidentForJob() {
        BpmnModelInstance sourceProcess = ((ServiceTaskBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).userTaskBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).timerWithDate(TIMER_DATE)).serviceTask("failingTask").camundaClass(FailingDelegate.class.getName())).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(USER_TASK_ID, "newUserTask").changeElementId(BOUNDARY_ID, "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job jobBeforeMigration = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)jobBeforeMigration);
        this.executeJob(jobBeforeMigration);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, "newUserTask").mapActivities(BOUNDARY_ID, "newBoundary").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Job jobAfterMigration = (Job)this.rule.getManagementService().createJobQuery().jobId(jobBeforeMigration.getId()).singleResult();
        Assert.assertNotNull((Object)jobAfterMigration);
        Incident incidentAfterMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)jobAfterMigration.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)"newBoundary", (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)jobAfterMigration.getJobDefinitionId(), (Object)incidentAfterMigration.getJobDefinitionId());
    }

    @Test
    public void testUpdateEventMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).message("newMessage")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(BOUNDARY_ID, MESSAGE_NAME, BOUNDARY_ID, "newMessage");
        this.rule.getRuntimeService().correlateMessage("newMessage");
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).signal("newSignal")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(BOUNDARY_ID, SIGNAL_NAME, BOUNDARY_ID, "newSignal");
        this.rule.getRuntimeService().signalEventReceived("newSignal");
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventTimer() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).timerWithDuration("PT50M")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusMinutes(50).toDate();
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), BOUNDARY_ID, newDueDate);
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    protected void executeJob(Job job) {
        ManagementService managementService = this.rule.getManagementService();
        while (job != null && job.getRetries() > 0) {
            try {
                managementService.executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)managementService.createJobQuery().jobId(job.getId()).singleResult();
        }
    }

    @Test
    public void testUpdateEventSignalNameWithExpression() {
        String signalNameWithExpression = "newSignal-${var}";
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).signal(signalNameWithExpression)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).build();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("var", "foo");
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan, variables);
        String resolvedSignalName = "newSignal-foo";
        this.testHelper.assertEventSubscriptionCreated(BOUNDARY_ID, resolvedSignalName);
        this.rule.getRuntimeService().signalEventReceived(resolvedSignalName);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventMessageNameWithExpression() {
        String messageNameWithExpression = "newMessage-${var}";
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).message(messageNameWithExpression)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).build();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("var", "foo");
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan, variables);
        String resolvedMessageName = "newMessage-foo";
        this.testHelper.assertEventSubscriptionCreated(BOUNDARY_ID, resolvedMessageName);
        this.rule.getRuntimeService().correlateMessage(resolvedMessageName);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateConditionalEventExpression() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).condition(FALSE_CONDITION)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).condition(VAR_CONDITION)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(BOUNDARY_ID, BOUNDARY_ID, null);
        this.testHelper.setAnyVariable(this.testHelper.snapshotAfterMigration.getProcessInstanceId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventKeepTrigger() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).signal("newSignal")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        HashMap<String, String> activities = new HashMap<String, String>();
        activities.put(USER_TASK_ID, USER_TASK_ID);
        activities.put(BOUNDARY_ID, BOUNDARY_ID);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(BOUNDARY_ID, BOUNDARY_ID, SIGNAL_NAME);
        EventSubscription eventSubscription = (EventSubscription)this.rule.getRuntimeService().createEventSubscriptionQuery().eventName("newSignal").singleResult();
        Assert.assertNull((Object)eventSubscription);
        Assert.assertEquals((long)1L, (long)this.rule.getRuntimeService().createEventSubscriptionQuery().count());
        this.rule.getProcessEngine().getRuntimeService().signalEventReceived(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventKeepTrigger() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).message("newMessage")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        HashMap<String, String> activities = new HashMap<String, String>();
        activities.put(USER_TASK_ID, USER_TASK_ID);
        activities.put(BOUNDARY_ID, BOUNDARY_ID);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(BOUNDARY_ID, BOUNDARY_ID, MESSAGE_NAME);
        EventSubscription eventSubscription = (EventSubscription)this.rule.getRuntimeService().createEventSubscriptionQuery().eventName("newMessage").singleResult();
        Assert.assertNull((Object)eventSubscription);
        Assert.assertEquals((long)1L, (long)this.rule.getRuntimeService().createEventSubscriptionQuery().count());
        this.rule.getProcessEngine().getRuntimeService().correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventKeepTrigger() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).timerWithDuration("PT5S")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).timerWithDuration("PT10M")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        HashMap<String, String> activities = new HashMap<String, String>();
        activities.put(USER_TASK_ID, USER_TASK_ID);
        activities.put(BOUNDARY_ID, BOUNDARY_ID);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated(BOUNDARY_ID, BOUNDARY_ID, "timer-transition");
        ManagementService managementService = this.rule.getManagementService();
        Job job = (Job)managementService.createJobQuery().singleResult();
        managementService.executeJob(job.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateConditionalBoundaryEventKeepTrigger() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder(USER_TASK_ID).boundaryEvent(BOUNDARY_ID).condition(FALSE_CONDITION)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        this.exceptionRule.expect(MigrationPlanValidationException.class);
        this.exceptionRule.expectMessage("Conditional event has to migrate with update event trigger.");
        this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, BOUNDARY_ID).build();
    }
}

